package com.example.mobapp_l_lukas;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.support.v4.view.GestureDetectorCompat;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.GestureDetector.OnGestureListener;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.os.Build;

public class MainActivity extends ActionBarActivity 
	implements OnGestureListener {

	private GestureDetectorCompat mDetector; 
	private int highScore = 0;
	
	private Boolean checked = false;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		mDetector = new GestureDetectorCompat(this,this); // context und gesture listener
		new DoSomething().execute();

	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	public void setHighScore(int hs) {
		highScore = hs;
		TextView text = (TextView)findViewById(R.id.textView2);
		text.setText(""+highScore);
		ProgressBar bar = (ProgressBar)findViewById(R.id.progressBar1);
		bar.setProgress(Math.min(bar.getMax(),hs));
	}

	public void displayScore(int s) {
		TextView text = (TextView)findViewById(R.id.textView4);
		text.setText(""+s);
	}
	
	public void onRestart(View v) {
		setHighScore(0);
		displayScore(0);
	}
	
	public void checkGravity(View v) {
		checked = !checked;
	}
	
	private class DoSomething extends AsyncTask<Void, Integer, Void> {
		protected Void doInBackground(Void... arg0) {
			while (true) {
				try {
					publishProgress(0);
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
	     }
		
	     protected void onProgressUpdate(Integer... progress) {
	    	 	if (!checked)
	    	 		return;
	    	 	
	    	 	ProgressBar bar = (ProgressBar)findViewById(R.id.progressBar1);
	 		int v = bar.getProgress();
	 		if (v==0)
	 			return;
	 		if (v>100)
	 			v = v-100;
	 		else
	 			v = 0;
	 			
	 		setHighScore(v);
	     }

	 }
		
	
	@Override
	public boolean onTouchEvent(MotionEvent event){ 
        this.mDetector.onTouchEvent(event);
        // Be sure to call the superclass implementation
        return super.onTouchEvent(event);
	}

	@Override
	public boolean onDown(MotionEvent arg0) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean onFling(MotionEvent arg0, MotionEvent arg1, float arg2,
			float arg3) {
		int s = Math.abs((int)arg2);
		if (s>highScore)
			setHighScore(s);
		displayScore(s);
		return true;
	}

	@Override
	public void onLongPress(MotionEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean onScroll(MotionEvent arg0, MotionEvent arg1, float arg2,
			float arg3) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void onShowPress(MotionEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean onSingleTapUp(MotionEvent arg0) {
		// TODO Auto-generated method stub
		return false;
	}

}
