package com.example.mobapp_l_asynctask;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import android.os.Build;

interface ProgressResult {
	void onProgressResult(Boolean canceled);
}

public class MainActivity extends ActionBarActivity 
	implements ProgressResult {
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
	
	public void startMain(View v) throws InterruptedException
	{
		ProgressBar bar = (ProgressBar)findViewById(R.id.progressBar1);
		bar.setProgress(0);
		for (int i=0; i<=10; ++i) {
			Thread.sleep(500);
			bar.setProgress(i*10);
		}
	}

	private class DoSomething extends AsyncTask<Void, Integer, Void> {
		protected Void doInBackground(Void... arg0) {
			for (int i=0; i<=10; ++i) {
				try {
					publishProgress(i*10);
					Thread.sleep(500);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			return null;
	     }
		protected void onPreExecute() {
	 		ProgressBar bar = (ProgressBar)findViewById(R.id.progressBar1);
	 		bar.setProgress(0);
	 		Button btn = (Button)findViewById(R.id.Button3);
			btn.setEnabled(false);
			TextView text = (TextView)findViewById(R.id.textView1);
			text.setText("0%");
		}
		
	     protected void onProgressUpdate(Integer... progress) {
	 		ProgressBar bar = (ProgressBar)findViewById(R.id.progressBar1);
			bar.setProgress(progress[0]);
			TextView text = (TextView)findViewById(R.id.textView1);
			text.setText(""+progress[0]+"%");
	     }

	     protected void onPostExecute(Void arg0) {
	 		ProgressBar bar = (ProgressBar)findViewById(R.id.progressBar1);
			bar.setProgress(0);
	 		Button btn = (Button)findViewById(R.id.Button3);
			btn.setEnabled(true);
			TextView text = (TextView)findViewById(R.id.textView1);
			text.setText("");
	     }

	 }
		
	public void startAsync(View v)
	{
		new DoSomething().execute();
	}


	private class DoSomethingElse extends AsyncTask<Void, Integer, Void> {
		private Context context;
		ProgressDialog progressDialog;
		ProgressResult progressResult;
						
		public DoSomethingElse(Context c, ProgressResult call) {
			context = c;
			progressResult = call;
		}

		protected Void doInBackground(Void... arg0) {
			for (int i=0; i<=10; ++i) {
				try {
					publishProgress(i*10);
					if (isCancelled())
						break;
					Thread.sleep(500);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			return null;
	    }
		
		protected void onPreExecute() {
			progressDialog = new ProgressDialog(context);
			progressDialog.setMessage("do something else ...");
			progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
			progressDialog.setProgress(0);
			progressDialog.setMax(100);		
			progressDialog.setOnCancelListener(new OnCancelListener() {
		        @Override
		        public void onCancel(DialogInterface dialog) {
		    	 		Toast.makeText(context,"canceled", Toast.LENGTH_SHORT).show();
		    	 		progressResult.onProgressResult(true);
		        }
		    });
			progressDialog.show();
		}
		
		protected void onProgressUpdate(Integer... progress) {
	    	 	progressDialog.setProgress(progress[0]);
	    }

	    protected void onPostExecute(Void arg0) {
	    	 	progressDialog.dismiss();
	    	 	progressDialog = null;
	    	 	Toast.makeText(context,"done", Toast.LENGTH_SHORT).show();
	    	 	progressResult.onProgressResult(false);
	    }
	}

	public DoSomethingElse async;
	
	public void onProgressResult(Boolean canceled) {
	 	Toast.makeText(this,"dlg canceled? "+canceled, Toast.LENGTH_SHORT).show();
		if (canceled && (!async.isCancelled()))	// not necessary
			async.cancel(true);
	}
	
	public void startDialog(View v)
	{
		async = new DoSomethingElse(this,this);
		async.execute();
	}
}
