/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.hardware;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import org.openintents.sensorsimulator.db.SensorSimulatorConvenience;
import org.openintents.sensorsimulator.hardware.Sensor;
import org.openintents.sensorsimulator.hardware.SensorEvent;
import org.openintents.sensorsimulator.hardware.SensorEventListener;
import org.openintents.sensorsimulator.hardware.SensorManagerSimulator;
import org.openintents.sensorsimulator.hardware.SensorNames;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SensorSimulatorClient {
    static final String TAG = "Hardware";
    private static final boolean LOG_PROTOCOL = false;
    private Context mContext;
    private SensorSimulatorConvenience mSensorSimulatorConvenience;
    protected boolean connected = false;
    Socket mSocket;
    PrintWriter mOut;
    BufferedReader mIn;
    private ArrayList<Listener> mListeners = new ArrayList();
    private SensorManagerSimulator mSensorManager;
    private int DELAY_MS_FASTEST = 0;
    private int DELAY_MS_GAME = 20;
    private int DELAY_MS_UI = 60;
    private int DELAY_MS_NORMAL = 200;
    private static final int MSG_UPDATE_SENSORS = 1;
    private static int MAX_SENSOR = 12;
    private float[][] mValues = new float[MAX_SENSOR][];
    private boolean[] mValuesCached = new boolean[MAX_SENSOR];
    private String barcode;
    protected Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                long current = SystemClock.uptimeMillis();
                long nextTime = current + (long)SensorSimulatorClient.this.DELAY_MS_NORMAL;
                for (int i = 0; i < MAX_SENSOR; ++i) {
                    ((SensorSimulatorClient)SensorSimulatorClient.this).mValuesCached[i] = false;
                    if (SensorSimulatorClient.this.mValues[i] != null) continue;
                    Log.d((String)SensorSimulatorClient.TAG, (String)("Create cache for sensor " + i));
                    ((SensorSimulatorClient)SensorSimulatorClient.this).mValues[i] = new float[3];
                }
                for (Listener l : SensorSimulatorClient.this.mListeners) {
                    if (current >= l.mNextUpdateTime) {
                        int sensorbit = 1;
                        for (int i = 0; i < MAX_SENSOR; ++i) {
                            if (SensorSimulatorClient.hasSensor(l.mSensors, sensorbit)) {
                                SensorEvent event;
                                if (!SensorSimulatorClient.this.mValuesCached[i]) {
                                    SensorSimulatorClient.this.readSensor(sensorbit, SensorSimulatorClient.this.mValues[i], SensorSimulatorClient.this.barcode);
                                    ((SensorSimulatorClient)SensorSimulatorClient.this).mValuesCached[i] = true;
                                }
                                if (SensorSimulatorClient.this.barcode != null) {
                                    event = new SensorEvent(SensorSimulatorClient.this.mContext, SensorSimulatorClient.this.barcode, sensorbit);
                                    SensorSimulatorClient.this.barcode = null;
                                    l.mSensorListener.onSensorChanged(event);
                                } else {
                                    event = new SensorEvent(SensorSimulatorClient.this.mContext, SensorSimulatorClient.this.mValues[i], sensorbit);
                                    l.mSensorListener.onSensorChanged(event);
                                }
                            }
                            ++sensorbit;
                        }
                        l.mNextUpdateTime += l.mDelay;
                        if (l.mNextUpdateTime < current) {
                            l.mNextUpdateTime = current;
                        }
                    }
                    if (l.mNextUpdateTime >= nextTime) continue;
                    nextTime = l.mNextUpdateTime;
                }
                if (SensorSimulatorClient.this.mListeners.size() > 0) {
                    this.sendMessageAtTime(this.obtainMessage(1), nextTime);
                }
            }
        }
    };

    protected SensorSimulatorClient(Context context, SensorManagerSimulator sensorManager) {
        this.mContext = context;
        this.mSensorManager = sensorManager;
        this.mSensorSimulatorConvenience = new SensorSimulatorConvenience(this.mContext);
    }

    protected void connect() {
        this.mSocket = null;
        this.mOut = null;
        this.mIn = null;
        Log.i((String)TAG, (String)"Starting connection...");
        String ipaddress = this.mSensorSimulatorConvenience.getPreference("IP address");
        String socket = this.mSensorSimulatorConvenience.getPreference("Socket");
        Log.i((String)TAG, (String)("Connecting to " + ipaddress + " : " + socket));
        try {
            this.mSocket = new Socket(ipaddress, Integer.parseInt(socket));
            this.mOut = new PrintWriter(this.mSocket.getOutputStream(), true);
            this.mIn = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            Log.e((String)TAG, (String)("Don't know about host: " + ipaddress + " : " + socket));
            return;
        }
        catch (SocketTimeoutException e) {
            Log.e((String)TAG, (String)("Connection time out: " + ipaddress + " : " + socket));
            return;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Couldn't get I/O for the connection to: " + ipaddress + " : " + socket));
            Log.e((String)TAG, (String)"---------------------------------------------------------------");
            Log.e((String)TAG, (String)"Do you have the following permission in your manifest?");
            Log.e((String)TAG, (String)"<uses-permission android:name=\"android.permission.INTERNET\"/>");
            Log.e((String)TAG, (String)"---------------------------------------------------------------");
            System.exit(1);
        }
        Log.i((String)TAG, (String)"Read line...");
        String fromServer = "";
        try {
            fromServer = this.mIn.readLine();
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
        Log.i((String)TAG, (String)("Received: " + fromServer));
        if (fromServer.equals("SensorSimulator")) {
            this.connected = true;
            Log.i((String)TAG, (String)"Connected");
        } else {
            Log.i((String)TAG, (String)"Problem connecting: Wrong string sent.");
            this.disconnect();
        }
    }

    protected void disconnect() {
        if (this.connected) {
            Log.i((String)TAG, (String)"Disconnect()");
            try {
                this.mOut.close();
                this.mIn.close();
                this.mSocket.close();
            }
            catch (IOException e) {
                System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
                System.exit(1);
            }
            this.connected = false;
        }
    }

    protected ArrayList<Integer> getSensors() {
        String[] sensornames = this.getSupportedSensors();
        ArrayList<Integer> sensors = SensorNames.getSensorsFromNames(sensornames);
        return sensors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate) {
        boolean result;
        int delay = -1;
        switch (rate) {
            case 0: {
                delay = this.DELAY_MS_FASTEST;
                break;
            }
            case 1: {
                delay = this.DELAY_MS_GAME;
                break;
            }
            case 2: {
                delay = this.DELAY_MS_UI;
                break;
            }
            case 3: {
                delay = this.DELAY_MS_NORMAL;
                break;
            }
            default: {
                return false;
            }
        }
        ArrayList<Listener> arrayList = this.mListeners;
        synchronized (arrayList) {
            Listener l = null;
            for (Listener i : this.mListeners) {
                if (i.mSensorListener != listener) continue;
                l = i;
                break;
            }
            if (this.mListeners.isEmpty()) {
                l = new Listener(listener, sensor, delay);
                result = this.enableSensor(sensor, delay);
                if (result) {
                    this.mListeners.add(l);
                    sensor.addSensorToList(sensor.sensorToRegister);
                    sensor.addSensor(0);
                    this.mListeners.notify();
                }
            } else {
                l = new Listener(listener, sensor, delay);
                result = this.enableSensor(sensor, delay);
                if (result) {
                    l.addSensors(sensor, delay);
                    this.mListeners.add(l);
                    sensor.addSensor(0);
                    this.mListeners.notify();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterListener(SensorEventListener listener, Sensor sensor) {
        ArrayList<Listener> arrayList = this.mListeners;
        synchronized (arrayList) {
            Iterator<Listener> itr = this.mListeners.iterator();
            do {
                boolean result;
                Listener element;
                if (!(element = itr.next()).hasSensor(sensor.sensorToRemove) || !(result = this.enableSensor(sensor, -1))) continue;
                if (this.mListeners.size() == 1) {
                    this.mListeners = new ArrayList();
                } else {
                    this.mListeners.remove(element);
                }
                sensor.removeSensorFromList(sensor.sensorToRemove);
                sensor.removeSensor(0);
                break;
            } while (itr.hasNext());
        }
    }

    protected void unregisterListener(SensorEventListener listener) {
        if (this.mListeners.size() != 0) {
            int i;
            Iterator<Listener> itr = this.mListeners.iterator();
            Sensor mSensor = itr.next().mSensor;
            ArrayList<Integer> sensors = mSensor.getList();
            int[] sensor = new int[sensors.size()];
            for (i = 0; i < sensors.size(); ++i) {
                if (sensors.get(i) == null) continue;
                sensor[i] = sensors.get(i);
            }
            for (i = 0; i < sensor.length; ++i) {
                mSensor.removeSensor(sensor[i]);
                this.unregisterListener(listener, mSensor);
            }
        }
    }

    private boolean enableSensor(Sensor sensorAdd, int delay) {
        String sensorString = null;
        boolean result = false;
        sensorString = delay == -1 ? SensorNames.getSensorName(sensorAdd.sensorToRemove) : SensorNames.getSensorName(sensorAdd.sensorToRegister);
        try {
            this.setSensorUpdateDelay(sensorString, delay);
            result = true;
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)("Sensor " + sensorString + " not supported"));
        }
        if (!this.mHandler.hasMessages(1)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        }
        sensorString = null;
        return result;
    }

    static boolean hasSensor(ArrayList<Integer> sensors, int sensor) {
        for (int i = 0; i < sensors.size(); ++i) {
            if (sensors.get(i) != sensor) continue;
            return true;
        }
        return false;
    }

    private void readSensor(int sensorbit, float[] sensorValues, String barcode2) {
        String sensorname = SensorNames.getSensorName(sensorbit);
        try {
            this.readSensor(sensorname, sensorValues, barcode2);
        }
        catch (IllegalStateException e) {
            Log.d((String)TAG, (String)"Sensor not enabled -> enable it now");
        }
    }

    protected int getNumSensorValues(int sensorbit) {
        String sensorname = SensorNames.getSensorName(sensorbit);
        return this.getNumSensorValues(sensorname);
    }

    protected String[] getSupportedSensors() {
        this.mOut.println("getSupportedSensors()");
        String[] sensors = new String[]{""};
        int num = 0;
        try {
            String numstr = this.mIn.readLine();
            num = Integer.parseInt(numstr);
            sensors = new String[num];
            for (int i = 0; i < num; ++i) {
                sensors[i] = this.mIn.readLine();
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
        return sensors;
    }

    protected int getNumSensorValues(String sensor) {
        this.mOut.println(sensor);
        this.mOut.println("getNumSensorValues()");
        int num = 0;
        try {
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            num = Integer.parseInt(numstr);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
        return num;
    }

    protected void readSensor(String sensor, float[] sensorValues, String barcode2) {
        if (sensorValues == null) {
            throw new NullPointerException("readSensor for '" + sensor + "' called with sensorValues == null.");
        }
        this.mOut.println("readSensor()\n" + sensor);
        int num = 0;
        try {
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            if (numstr.compareTo("throw IllegalStateException") == 0) {
                throw new IllegalStateException("Sensor '" + sensor + "' is currently not enabled.");
            }
            num = Integer.parseInt(numstr);
            if (sensorValues.length < num) {
                throw new ArrayIndexOutOfBoundsException("readSensor for '" + sensor + "' called with sensorValues having too few elements (" + sensorValues.length + ") to hold the sensor values (" + num + ").");
            }
            for (int i = 0; i < num; ++i) {
                String val = this.mIn.readLine();
                sensorValues[i] = Float.parseFloat(val);
                if (val.length() != 13) continue;
                this.barcode = barcode2 = val;
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
        catch (NullPointerException e2) {
            Log.e((String)TAG, (String)"Error reading sensors: Is the client running?");
            System.exit(1);
        }
    }

    protected void setSensorUpdateDelay(String sensor, int updateDelay) {
        if (updateDelay == -1) {
            this.unsetSensorUpdateRate(sensor);
            return;
        }
        this.mOut.println("setSensorUpdateDelay()");
        this.mOut.println(sensor);
        this.mOut.println("" + updateDelay);
        try {
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
    }

    protected void unsetSensorUpdateRate(String sensor) {
        try {
            this.mOut.println("unsetSensorUpdateRate()");
            this.mOut.println(sensor);
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
        }
        catch (Exception e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener {
        private SensorEventListener mSensorListener;
        private Sensor mSensor;
        private ArrayList<Integer> mSensors;
        private int mDelay;
        private long mNextUpdateTime;

        ArrayList<Integer> addSensors(Sensor sensor, int delay) {
            int sensors = sensor.sensorToRegister;
            sensor.addSensorToList(sensors);
            this.mSensors.add(sensors);
            if (delay < this.mDelay) {
                this.mDelay = delay;
                this.mNextUpdateTime = 0L;
            }
            return this.mSensors;
        }

        boolean hasSensor(int sensor) {
            for (int i = 0; i < this.mSensors.size(); ++i) {
                if (this.mSensors.get(i) != sensor) continue;
                return true;
            }
            return false;
        }

        Listener(SensorEventListener listener, Sensor sensor, int delay) {
            this.mSensorListener = listener;
            this.mSensors = new ArrayList();
            this.mSensors.add(sensor.sensorToRegister);
            this.mDelay = delay;
            this.mNextUpdateTime = 0L;
            this.mSensor = sensor;
        }
    }
}

