package com.example.mobapp_k_scribble;

import com.example.mobapp_k_scribble.R;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector.OnGestureListener;
import android.view.MotionEvent;
import android.view.View;

public class PieChart extends View 
	implements OnGestureListener {
    

	Boolean mShowText;
	Bitmap bitmap;
	Paint paint;
	
	int width, height;
	
	public Boolean isScribble = true;
	Bitmap bmpIcon;
	
	private GestureDetectorCompat mDetector; 

	
	public PieChart(Context context) {
        super(context);
        mShowText = false;
        init();
	}
	
	public PieChart(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(
             attrs,
             R.styleable.PieChart,
             0, 0);

        try {
            mShowText = a.getBoolean(R.styleable.PieChart_showText, false);
        } finally {
            a.recycle();
        }
        init();
        
    }
	
	private void init() {
		paint = new Paint();
		paint.setColor(Color.RED);
		paint.setStyle(Paint.Style.FILL);
		
		bmpIcon = BitmapFactory.decodeResource(getResources(), R.drawable.ic_launcher);
		
		mDetector = new GestureDetectorCompat(getContext(),this); // context und gesture listener
	}

	public boolean isShowText() {
		   return mShowText;
	}

	public void setShowText(boolean showText) {
	   mShowText = showText;
	   invalidate();
	   requestLayout();
	}
	
	public void clear()
	{
		bitmap = Bitmap.createBitmap(width, height, Config.ARGB_8888);
		invalidate();
	}
		
    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        width = w;
        height = h;
        bitmap = Bitmap.createBitmap(width, height, Config.ARGB_8888);
    }
    
	@Override
	public boolean onTouchEvent(MotionEvent event){ 
		
		if (!isScribble)
		{
			this.mDetector.onTouchEvent(event);
			return super.onTouchEvent(event);
		}
		
		int action = event.getAction();
		int x = (int)event.getX();
		int y = (int)event.getY();
		
		if (x<0) x=0; else if (x>=width) x=width-1;
		if (y<0) y=0; else if (y>=height) y=height-1;
		
	    switch(action) {
	        case (MotionEvent.ACTION_DOWN) :
	            return true;
	        case (MotionEvent.ACTION_MOVE) :
	        	bitmap.setPixel(x,y, Color.BLUE);
	        	invalidate();
	            return true;
	        case (MotionEvent.ACTION_UP) :
	            return true;
	        default : 
	            return super.onTouchEvent(event);
	    } 
    }	

	@Override
	protected void onDraw(Canvas canvas) {
	   super.onDraw(canvas);
	   if (isShowText() || (!isScribble)) {
		   int x = width/2 - bmpIcon.getWidth()/2;
		   int y = height/2 - bmpIcon.getHeight()/2;
		   canvas.drawBitmap(bmpIcon,  x, y, paint);
	   }
	   if (isScribble)
		   canvas.drawBitmap(bitmap, 0, 0, paint);
	}
	
	@Override
	public boolean onDown(MotionEvent arg0) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean onFling(MotionEvent arg0, MotionEvent arg1, float arg2,
			float arg3) {
		// TODO Auto-generated method stub


		return false;
	}

	@Override
	public void onLongPress(MotionEvent arg0) {
		// TODO Auto-generated method stub
		//arg1.
		int w = bmpIcon.getWidth();
		int h = bmpIcon.getHeight();
		Bitmap targetBitmap = Bitmap.createBitmap(w, h, Config.ARGB_8888);
		Canvas canvas2 = new Canvas(targetBitmap);
		Matrix matrix = new Matrix();
		matrix.setRotate(90,w/2,h/2);
		canvas2.drawBitmap(bmpIcon, matrix, new Paint());
		//canvas.drawBitmap(bmpIcon,  x, y, paint);
		bmpIcon = targetBitmap;
		invalidate();
	}

	@Override
	public boolean onScroll(MotionEvent arg0, MotionEvent arg1, float arg2,
			float arg3) {
		// TODO Auto-generated method stub
		Log.v("!!!","scroll "+arg2+" "+arg3);
		return false;
	}

	@Override
	public void onShowPress(MotionEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean onSingleTapUp(MotionEvent arg0) {
		// TODO Auto-generated method stub
		return false;
	}

}
