package com.example.mobapp_f_fragmentusage;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.Switch;
import android.widget.Toast;
import android.widget.ToggleButton;
import android.widget.ViewSwitcher;
import android.os.Build;

public class MainActivity extends ActionBarActivity {

	Boolean land=false;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		if (savedInstanceState == null) {
			getSupportFragmentManager().beginTransaction()
					.add(R.id.fragmentcontainer, new PlaceholderFragment()).commit();
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
	
	public void toggleFragment(View v)
	{
		ToggleButton tb = (ToggleButton)findViewById(R.id.toggleButton1);
		if (tb.isChecked())
		{
			this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
		}
		else
		{
			this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
		}
		//Toast.makeText(this, "click", Toast.LENGTH_SHORT).show();
	}

	/**
	 * A placeholder fragment containing a simple view.
	 */
	public static class PlaceholderFragment extends Fragment {

		FragmentMaster fragMaster = null;
		FragmentDetails fragDetails = null;
		
		public PlaceholderFragment() {
		}

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container,
				Bundle savedInstanceState) {
			View rootView = inflater.inflate(R.layout.fragment_main, container,
					false);
			
			if (savedInstanceState==null) {
				fragMaster = new FragmentMaster();
				fragDetails = new FragmentDetails();
				
				getActivity().getSupportFragmentManager()
					.beginTransaction()
					.add(R.id.frameMaster, fragMaster)
					.add(R.id.frameDetails, fragDetails)
					.commit();

			}

			Switch sw = (Switch)(rootView.findViewById(R.id.switch1));
			// this is in fact a check for landscape or portrait mode
			if (sw!=null) {
				sw.setOnCheckedChangeListener(new OnCheckedChangeListener() {
					@Override
					public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
						switchDetailView(buttonView,isChecked);
					}
				});
			}
			
			return rootView;
		}
		public void switchDetailView(CompoundButton buttonView, boolean isChecked) {
			ViewSwitcher vs = (ViewSwitcher)(getActivity().findViewById(R.id.viewSwitcher1));
			vs.showNext();
		}
		
	}

}
