package com.example.mobapp_e_twofragments;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ToggleButton;
import android.os.Build;

public class MainActivity extends ActionBarActivity {

	Fragment1 frag1 = null;
	Fragment2 frag2 = null;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		if (savedInstanceState == null) {
			frag1 = new Fragment1();
			frag2 = new Fragment2();
			getSupportFragmentManager().beginTransaction()
					.add(R.id.fragmentcontainer, frag1).commit();
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	public void toggleFragment(View v)
	{
		ToggleButton tb = (ToggleButton)findViewById(R.id.toggleButton1);
		if (tb.isChecked())
		{
			getSupportFragmentManager()
				.beginTransaction()
				.replace(R.id.fragmentcontainer, frag2)
				.commit();	
		}
		else
		{
			getSupportFragmentManager()
				.beginTransaction()
				.replace(R.id.fragmentcontainer, frag1)
				.commit();	
		}
	}
	
	/**
	 * A placeholder fragment containing a simple view.
	 */
	public static class Fragment1 extends Fragment {

		public Fragment1() {
		}

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container,
				Bundle savedInstanceState) {
			View rootView = inflater.inflate(R.layout.fragment1, container,
					false);
			return rootView;
		}
	}
	
	public static class Fragment2 extends Fragment {

		public Fragment2() {
		}

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container,
				Bundle savedInstanceState) {
			View rootView = inflater.inflate(R.layout.fragment2, container,
					false);
			return rootView;
		}
	}

}
