// Author: A.Voss@FH-Aachen.de

#include <iostream>
#include <cstdlib>
#include <string>
using namespace std;

void Unlock()	{ cout << endl << "-> Unlock" << endl; }
void Lock()		{ cout << endl << "-> Lock" << endl; }
void Thankyou()	{ cout << endl << "-> Thx" << endl; }
void Alarm()	{ cout << endl << "-> Peeeeeep" << endl; }

enum State {Locked, Unlocked};
enum Event {Pass, Coin};

string PrintState(State s) {
	if (s==Locked)
		return "Locked";
	else if (s==Unlocked)
		return "Unlocked";
	else
		return "Unknown";
}

State fsm = Locked;	// for debug purpose only

void Transition(Event e)
{
	//static State s = Locked;
	switch(fsm)
	{
	case Locked:
		switch(e)
		{
		case Coin:
			fsm = Unlocked;
			Unlock();
			break;
		case Pass:
			Alarm();
			break;
		} 
		break;
	case Unlocked:
		switch(e)
		{
		case Coin:
			Thankyou();
			break;
		case Pass:
			fsm = Locked;
			Lock();
			break;
		} 
		break;
	} 
}

int main()
{
    cout << endl << "start" << endl << endl;
    
    char c;
  
    do {
		cout << "current state: " << PrintState(fsm) << endl << endl;
		cout << "(c)oin (p)ass e(x)it: ";
		cin >> c;
		
		if (c=='c')
			Transition(Coin);
		else if (c=='p')
			Transition(Pass);
	} while (c!='x');
    
    cout << endl << "end" << endl << endl;
        
    return EXIT_SUCCESS;
}

