// Author: A.Voss@FH-Aachen.de

#include <iostream>
#include <cstdlib>
#include <cmath>
using namespace std;

double mysqrt_dbl(double a) {
    double xn = a, err;
    int n = 0;
    
    double maxerr = 1e-10;
    int nmax = 10;
    
    do {
		++n; xn = (xn + a/xn)*0.5; err = fabs(xn*xn-a);
		cout << "n=" <<n << ", xn=" << xn << ", err=" << err << endl;
	} while (err>maxerr && n<nmax);
	
	return xn;
}

int main()
{
    cout << endl << "start" << endl;
    
    double xn, a;
    
    a = 2.0; 
    
    xn = mysqrt_dbl(a);
    cout << "sqrt_dbl(" << a << ")=" << xn << endl << endl;

//    xn = mysqrt_gen<double,Numeric>(a);
//    cout << "sqrt_gen(" << a << ")=" << xn << endl << endl;

//    xn = mysqrt_gen<float,Numeric>((float)a);
//    cout << "sqrt_gen(" << a << ")=" << xn << endl << endl;
    
    cout << "end" << endl << endl;
        
    return EXIT_SUCCESS;
}

