// Author: A.Voss@FH-Aachen.de
//
// see more exceptional C++

#include <iostream>
#include <cstdlib>
using namespace std;

class A {
public:
	virtual ~A() { }
	string Name() { return DoName(); }
private:
	virtual string DoName() { return "A"; }
};

class B1 : virtual public A
{
	string DoName() { return "B1"; }
};

class B2 : virtual public A
{
	string DoName() { return "B2"; }
};

#ifndef _NO_MI
class D : public B1, public B2 
{
	string DoName() { return "D_MI"; }
};
#else
class D ...
#endif

void f1(A& x)	{ cout << "f1:" << x.Name() << endl; }
void f2(B1& x)	{ cout << "f2:" << x.Name() << endl; }
void f3(B2& x)	{ cout << "f3:" << x.Name() << endl; }

void g1(A x)	{ cout << "g1:" << x.Name() << endl; }
void g2(B1 x)	{ cout << "g2:" << x.Name() << endl; }
void g3(B2 x)	{ cout << "g3:" << x.Name() << endl; }

int main()
{
    cout << "surprise?" << endl << endl;
 
	D d;
		
	// Part I
	
	f1(d);
	f2(d);
	f3(d);

	g1(d);
	g2(d);
	g3(d);
	
	cout << endl;

	cout << "sizeof(A)=" << sizeof(A) 
		 << " sizeof(B1)=" << sizeof(B1)
		 << " sizeof(B2)=" << sizeof(B2)
		 << " sizeof(D)=" << sizeof(D)
	<< endl << endl;

	// Part II (evtl. unmoeglich ...)

	B1* pb1 = &d;
	B2* pb2 = &d;
	B1& rb1 = d;
	B2& rb2 = d;
	
	cout << ( (dynamic_cast<D*>(pb1) != 0) ? "ok " : "bad " );
	cout << ( (dynamic_cast<D*>(pb2) != 0) ? "ok " : "bad " );
       
    try { dynamic_cast<D&>(rb1); cout << "ok "; } catch(...) { cout << "bad "; }
    try { dynamic_cast<D&>(rb2); cout << "ok "; } catch(...) { cout << "bad "; }

	cout << endl;
        
    return EXIT_SUCCESS;
}

