import java.util.List;               // Rueckgabetyp von `readAllLines'
import java.util.ArrayList;          // konkreter Typ der Messwerteliste
import java.nio.file.Files;          // wegen `readAllLines'
import java.nio.file.Path;           // wegen `of'
import java.io.IOException;          // Ausnahme von`readAllLines'
import java.io.PrintWriter;
import java.io.File;

/**
 * Jedes Objekt dieser Klasse speichert eine Liste von Messwerten,
 * die aus einer Datei stammen.
 * Zu diesen Messwerten bietet die Klasse laut Aufgabentext (A1 von java-pr02 im
 * WS 2024) Operationen wie z. B. Minimum- und Maximumberechnung an.<br>
 * Autor: Juergen Dietel und andere, ITC/CSE/MATSE, DI 15.10.2024
 */
public class Messreihe {

  /** Liste mit den eingelesenen Messwerten */
  private List<Double> liste;

  /**
   * Liest die uebergebene Datei ein und extrahiert alle Messwerte.
   *
   * Format der Datei:<br>
   * - pro Zeile eine Zahl<br>
   * - erste Zahl: Anzahl der Messwerte<br>
   * - Leerzeilen erlaubt
   * - mit `%' beginnende Kommentarzeilen erlaubt<br>
   *
   * @param   dateiname                 Name der Datei mit den Messwerten
   * @throws  IOException               falscher Dateiname oder Messwert keine Zahl
   *                                    oder keine Messwerte vorhanden oder
   *                                    zu wenige oder zu viele Messwerte
   */
  public Messreihe(String dateiname) throws IOException {
    // TODO: Fehlerbehandlung
    List<String> liste = null;
    liste = Files.readAllLines(Path.of(dateiname));      // Dateiinhalt holen
    this.liste = wandleListe(liste);                     // Gelesenes betrachten
  }

  /** Hilfsmethode zur Wandlung der Stringliste in eine `double'-Liste */
  private List<Double> wandleListe(List<String> liste) throws IOException {

    // TODO: Fehlerbehandlung
    List<Double> erg        = new ArrayList<>();
    int          lineCount  =  0;  // zaehlt die tatsaechlich gelesenen Messwerte
    int          linesTotal = -1;  // Sollwert fuer Anzahl an Messwerten
    for (String s: liste) {
      if (! s.isEmpty() && s.charAt(0) != '%') {
        if (linesTotal == -1) {              // Sollwert noch unbekannt?
          linesTotal = Integer.parseInt(s);  // => nun bestimmen
        } else {                             // Sollwert schon bekannt?
          erg.add(Double.parseDouble(s));    // Messwert einfuegen
          lineCount++;                       // und zaehlen
        }
      }
    }
    return erg;
  }

  /**
   * a) sucht nach dem groessten Messwert und gibt diesen zurueck
   *
   * @return  groesster Messwert der im aktuellen Objekt gespeicherten Daten
   */
  public double getMax() {
    // TODO: Implementation
    return 0.0;
  }

  /**
   * b) sucht nach dem kleinsten Messwert und gibt diesen zurueck
   *
   * @return  kleinster Messwert der im aktuellen Objekt gespeicherten Daten
   */
  public double getMin() {
    // TODO: Implementation
    return 0.0;
  }

  /**
   * c) prueft, ob alle in der Liste vorhandenen Werte identisch sind
   *
   * @return  true, falls nur identische Werte vorliegen, sonst false
   */
  public boolean isEinheitlich() {
    // TODO: Implementation
    return true;
  }

  /**
   * d) gibt die Anzahl der Messwerte zurueck
   *
   * @return  Anzahl der Messwerte
   */
  public int getAnzahl() {
    // TODO: Implementation
    return 0;
  }

  /**
   * e) legt die Summe der Messwerte in einer Datei mit festem Namen
   * `Summe.txt' ab.
   */
  public void summeSpeichern() throws IOException {

    // Algorithmus: einen `Printwriter' erzeugen und diesen ganz normal
    //              per `print' oder `println' (wie mit Hilfe von
    //              `System.out' bei Ausgaben auf den Bildschirm)
    //              in die Datei schreiben lassen.
    //              Dabei hilft `try with ressources' sehr.
    // TODO: Implementation
  }
}

