import java.io.FileNotFoundException;  // Ausnahme von `PrintWriter(File)'
import java.util.NoSuchElementException;
import java.io.File;                   // noetig fuer `PrintWriter(File)'
import java.util.List;                 // Rueckgabetyp von`readAllLines'
import java.nio.file.Files;            // wegen `readAllLines'
import java.nio.file.Path;             // wegen `of'
import java.io.IOException;            // Ausnahme von`readAllLines'
import java.io.PrintWriter;            // Textdatei zeilenweisen beschreiben

// a) Ein Objekt dieser Art kann eine Entfernungstabelle aus gewissen Dateien
// erzeugen und gewisse Operationen an einer solchen Tabelle vornehmen.<br>
// Geloest werden hiermit die Aufgaben der A2 von java-pr02 im WS 2024.<br>
// Autor: Juergen Dietel, ITC/CSE/MATSE, DI 15.10.2024
public class Entfernungstabelle {

  // nuetzliche symbolische Konstanten fuer die Namen der
  // vorgegebenen Testdateien:
  public static final String STAEDTE      = "Staedte.txt";
  public static final String ENTFERNUNGEN = "Entfernungen.txt";

  // Attribute:
  private List<String> staedtenamen = null;
  private int[][]      entfernungen = null;

  // b) ein Objekt aus den Inhalten der Staedtedatei `n1' und der
  // Entfernungsdatei `n2' erzeugen
  public Entfernungstabelle(String n1, String n2) throws IOException {
    liesStaedte(n1);
    liesEntfernungen(n2);
  }

  private void liesStaedte(String dateiname) throws IOException {
    // ganz einfach, weil in jeder Zeile der Datei genau ein Stadtname steht:
    // TODO: Implementation
  }

  private void liesEntfernungen(String dateiname) throws IOException {
    // Die Groesse der benoetigten Entfernungsmatrix sollte nun bekannt
    // sein durch die Anzahl der eingelesenen Staedtenamen.
    // Die Datei mit der Entfernungstabelle wird wieder zeilenweise als
    // Stringliste gelesen, so dass jeder String erstmal in seine
    // wesentlichen Bestandteile zerlegt werden muss (mit `String.split').
    // Achtung: Weil in der Entfernungstabelle auch mehrere Leerzeichen
    //          als Trennzeichen auftreten koennen, muss der regulaere
    //          Ausdruck, dem man `split' uebergibt, etwas komplexer
    //          ausfallen als gedacht: mindestens ein Leerzeichen.
    int  anzahl         = this.staedtenamen.size();
    this.entfernungen   = new int[anzahl][anzahl];
    List<String> zeilen = Files.readAllLines(Path.of(dateiname));
    for (int i = 0; i < zeilen.size(); ++i) {
      String zeile = zeilen.get(i);
      String[] zahlen = zeile.split(" +");
      for (int j = 0; j < zahlen.length; ++j)
        this.entfernungen[i][j] = Integer.parseInt(zahlen[j]);
    }
  }

  // c) die Entfernung der beiden genannten Staedte ermitteln
  public int getEntfernung(String stadt1, String stadt2) {
    int entf = 0;
    // Algorithmus:
    // Jede der beiden genannten Staedte muss in der Liste der
    // gespeicherten Staedte gesucht und so der Index ermittelt
    // werden. Dieser dient dann zur Indizierung der Entfernungsmatrix,
    // die so die gesuchte Entfernung liefert:
    int index1 = gibIndex(stadt1);
    int index2 = gibIndex(stadt2);
    try {                                          // Indizierung probieren
      entf = this.entfernungen[index1][index2];
    } catch (ArrayIndexOutOfBoundsException ex) {  // misslungen?
                                                   // => Ausnahme ummuenzen
      throw new NoSuchElementException("Entweder " + stadt1 + " oder " +
                                       stadt2 + " gibt es nicht!");
    }
    return entf;
  }

  // den Index von `stadt' in der Liste der Staedtenamen bestimmen
  private int gibIndex(String stadt) {  // c) Hilfsmethode
    // TODO: Implementation
    return 0;
  }

  // d) die zusammengeworfene Tabelle im gewuenschten Format in Datei schreiben,
  //    wozu die weiter unten stehenden Hilfsmethoden benutzt werden
  public void speichereTabelle(String dateiname) throws FileNotFoundException {
    int max = laengsteStadt();
    try (PrintWriter datei = new PrintWriter(new File(dateiname))) {
      ueberschriftSchreiben(datei, max);
      tabelleSchreiben(datei, max);
    }
  }

  // in der Liste der Staedtenamen den Index der Stadt mit dem laengsten bestimmen
  private int laengsteStadt() {
    // TODO: Implementation
    return 0;
  }

  // die Ueberschrift der zu erzeugenden Tabelle in die Datei schreiben
  // mit allen gemaess Aufgabentext gekuerzten Staedtenamen wie in diesem
  // Beispiel:
  //                Ber Bre Dre Due Erf
  // mit `max' als Laenge des laengsten Staedtenamens.
  // Dabei ist `datei' schon offen und muss nur noch mit Hilfe der
  // Operationen `print' oder `println' geeignet gefuellt werden.
  private void ueberschriftSchreiben(PrintWriter datei, int max) {
    // TODO: Implementation
  }

  private void tabelleSchreiben(PrintWriter datei, int max) {
    for (int i = 0; i < this.staedtenamen.size(); ++i) {
      datei.printf("%-" + (max+4) + "s", staedtenamen.get(i));
      for (int entf: this.entfernungen[i])
        datei.printf("%4d", entf);
      datei.println();
    }
  }
}

// Fazit:
// - Der Einfachheit halber wird eine eventuelle Ausnahme beim Lesen
//   von Dateien immer durchgelassen und muss daher im Kopf der
//   entsprechenden Methoden deklariert werden.
// - Ein brutales Programmende beim Fangen dieser Ausnahme ist meist
//   keine gute Alternative!
