import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;

import junit.framework.TestCase;

public class BisektionTest01 extends TestCase
{
  // Datei Pfade fr Eingabe, Ausgabe und Kontrolle
  private String eingabeDatei = null;
  private String ausgabeDatei = null;
  private String kontrollDatei = null;
  
  // Genauigkeitsvariablen fr Datei vergleich  
  private int genauigkeit;
  
  // Genauigkeitsvariable fr Bisektion berechnung  
  private int iterationsschritteBisektion;
  
  // Genauigkeitsvariable fr Sinus berechnung   
  private int iterationsschritteSinus;
  
  //-----------------------------------------------------------------------------setUp 
  protected void setUp()
  {   
    eingabeDatei = "Nullstellen//eingabe.txt";
    ausgabeDatei = "Nullstellen//ausgabe.txt";
    kontrollDatei = "Nullstellen//kontrolle.txt";
    
    genauigkeit = 7;
    iterationsschritteBisektion = 20;
    iterationsschritteSinus = 20;
  }
 
  //-----------------------------------------------------------------------------tearDown
  protected void tearDown()
  {
    eingabeDatei = null;
    ausgabeDatei = null;
    kontrollDatei = null;
  }
  
  //-----------------------------------------------------------------------------testNullstellenBerechnung  
  public final void testNullstellenBerechnung() throws NumberFormatException, Exception
  {
    //  Beinhaltet jeweils eine Zeile der Datei
    double sZeile1 ;
    //  Beinhaltet jeweils eine Zeile der Datei
    double sZeile2 ;
    //  Mit der Variablen kann auf die Datei zugegriffen werden
    Scanner scDatei = null;
    //  Die Ausgabe Datei wird erzeugt
    FileWriter fDatei = null;

    Bisektion nst = null;

    
    //-----------------------------------------------------------------------------Anfang
    try
    {
        scDatei = new Scanner( new File( eingabeDatei ) );
    }
    catch ( FileNotFoundException e )
    {
      fail("Datei nicht vorhanden");
    }
    //-----------------------------------------------------------------------------Ende   

    
    //-----------------------------------------------------------------------------Anfang
    try
    {     
        fDatei = new FileWriter( ausgabeDatei );     
    }
    catch ( IOException e )
    {
      fail("Datei kann nicht angelegt oder geaendert werden");
    }
    //-----------------------------------------------------------------------------Ende
  
    do
    {
      // 2 Zeilen lesen und double Zahl generieren
      sZeile1 = scDatei.nextDouble();
      sZeile2 = scDatei.nextDouble();

      // Bisektion wird initialisiert
      nst = new Bisektion(sZeile1, sZeile2);
      
      // Sinus iterationsschritte wird gesetzt
      nst.setSinusSchritte(iterationsschritteSinus);
      
      // Bisektion iterationsschritte wird gesetzt
      nst.setBisektionSchritte(iterationsschritteBisektion);

      // Ergebnis wird in Datei geschrieben
      fDatei.write(nst.getNullstelle() + "\n");
    }
    while (scDatei.hasNextLine());

    // Der Datei verweis wird geschlossen
    scDatei.close();
    fDatei.close();
  
    // Ausgabe- und Kontrolldatei werden verglichen    
    assertTrue(Dateivergleich.compare(ausgabeDatei,kontrollDatei,genauigkeit));
  }
  

  public static void main(String args[])
  {
    junit.swingui.TestRunner.run(BisektionTest01.class);
  }
  
}

