

public class Sinus
{
  
  private double    punkt = 0;          // Der Punkt, an dem die Funktion ausgewertet wird
  private int       iterSchritte = 10;  // Iterationsschritte fr Nherungsberechnung
  
  /**
   * Der Klasse wird der Punkt bergeben, an dem die Sinus Funktion
   * ausgewertet werden soll.
   * @param i Der Punkt fr die Nherungsberechnung
   */
  public Sinus(double i){
    // Punkt wird in Member-Variablen gespeichert
    punkt = i;
  }
  
  /**
   * Der Klasse wird der Punkt bergeben, an dem die Sinus Funktion
   * ausgewertet werden soll.
   * Der Benutzer kann die Anzahl der Iterationsschritte bestimmen, die
   * whrend der Nherung die Berechnugn steuern.
   * @param i Der Punkt fr die Nherungsberechnung
   * @param n Anzahl der Iterationsschritte.
   * @throws Exception
   */
  public Sinus(double i, int n) throws Exception{
    // Punkt wird in Member-Variable gespeichert
    punkt = i;
    // Die iterationsschritte mssen Positiv grsser 0 sein
    // damit sie Aktzeptiert werden knnen.
    if(n<1)
      throw new Exception("Schrittgrsse muss >0 sein");
    // Iterationsschritte werden in Member-Variable gespeichert
    iterSchritte = n;
  }
  
  /**
   * Diese Methode Berechnet die Fakultt einer integer Zahl n.
   * n!
   * Das Ergebnis wird als double zurckgeliefert.
   * @param n int Die zu berechnende Fakultt
   * @return das ergebnis der Fakultt Berechnung
   * @throws Exception Falls eine negative Fakultt berechnet werden soll
   */
  public static double fakultaet(int n) throws Exception{
    // Prfen ob eine negative Fakultt berechnet werden soll
    if(n<0)
      throw new Exception("Wert negativ");
    // 0 Fakultt ist 1 und wird gesondert behandelt
    if(n==0)
      return 1;
    // Das Ergebnis wird mit 1 initialisiert
    double erg = 1;
    
    /*
     * Da 0! besondert behandelt wurde, startet die Schleife bei 1 und
     * die Variable erg wurde zuvor mit 1 initialisiert.
     * Die Fakultt wird in der Schleife berechnet
     */
    for(int s = 1; s<=n; s++)
      erg *= s;
    
    // Das Ergebnis der Fakultt wird zurckgeliefert
    return erg;
  }
  
  /**
   * Die Nherug fr die Sinus Funktion wird mit Hilfe einer Reihe berechnet
   * Reihe n=0 bis iterSchritte(vom Benutzer gesetzt)
   * (-1)^n*x^(2*n+1)/((2*n+1)!)
   * @return Funktionswert des Sinus an der vom Benutzer gewhlten Stelle
   * @throws Exception tritt nur bei Problemen der Fakultt berechnung auf
   */
  public double getNaeherung() throws Exception{
    // Das Ergebnis wird mit dem Punkt des Benutzers initialisiert
    double erg = punkt;
    // Die Reihe wird von 1 bis iterSchritte berechnet und in erg gespeichert
    for(int n = 1; n<iterSchritte; n++){
      erg += Math.pow(-1,n)*Math.pow(punkt,(2*n+1))/fakultaet(2*n+1);
    }
    // Ergebnis wird zurckgeliefert
    return erg;
  }
    
}
