import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;

import junit.framework.TestCase;

public class SinusTest extends TestCase
{
  // Testvariablen fr Fakultt berprfung
  private int       fakZahl1;
  private double    fakErg1;
  // Testvariablen fr Fakultt berprfung  
  private int       fakZahl2;
  private double    fakErg2;
  
  // Datei Pfade fr Eingabe, Ausgabe und Kontrolle
  private String eingabeDatei = null;
  private String ausgabeDatei = null;
  private String kontrollDatei = null;
  
  // Genauigkeitsvariablen fr Datei vergleich
  private int genauigkeit;
  
  // Genauigkeitsvariable fr Sinus berechnung
  private int iterationsschritte;
  
 
  /**
   * Folgende Variablen werden gesetzt:
   * 
   * Fakulttsvariablen
   * Dateipfad
   * Genauigkeit fr Dateivergleich
   * Iterationsschritte fr Sinus berechnung
   */
  protected void setUp()
  {
    fakZahl1    = 5;
    fakErg1     = 120;
    fakZahl2    = 0;
    fakErg2     = 1;
    
    eingabeDatei = "Sinus//eingabe.txt";
    ausgabeDatei = "Sinus//ausgabe.txt";
    kontrollDatei = "Sinus//kontrolle.txt";
    
    genauigkeit = 5;
    iterationsschritte = 10;
  }
  
  /**
   * Mehrere Sinus konstruktor Aufrufe werden getestet.
   * @throws Exception
   */
  public final void testImplementierung() throws Exception
  {

    // Gltige Sinus Konstruktor Aufrufe
    Sinus sin = null;
    assertNull(sin);
    
    sin = new Sinus(0);
    assertNotNull(sin);
    sin = null;
    
    sin = new Sinus(60);
    assertNotNull(sin);
    sin = null;
    
    sin = new Sinus(-40);
    assertNotNull(sin);
    sin = null;
    
    sin = new Sinus(-20,1);
    assertNotNull(sin);
    sin = null;
    
    sin = new Sinus(10,400);
    assertNotNull(sin);
    sin = null;

    //  Ungltige Sinus Konstruktor Aufrufe
    
    
    /*
     * Der Funktionswert von 2 und -6 ist nicht zugelassen,
     * da -6 fr die Iteratioinsschritte steht und diese
     * grsser als 0 sein mssen 
     */
    try{
      sin = new Sinus(2,-6);
      assertFalse(this.getName()+" fehlgeschlagen",true);
    }catch(Exception e){
      System.out.println("Erfolgreich erkannt ("+this.getName()+"): "+e.getLocalizedMessage());
    }
    
    /*
     * Der Funktionswert von 30 und 0 ist nicht zugelassen,
     * da 0 fr die Iteratioinsschritte steht und diese
     * grsser als 0 sein mssen 
     */
    try{
      sin = new Sinus(30,0);
      assertFalse(this.getName()+" fehlgeschlagen",true);
    }catch(Exception e){
      System.out.println("Erfolgreich erkannt ("+this.getName()+"): "+e.getLocalizedMessage());
    }
  }
  
  /**
   * Diese Methode testet die Richtigkeit der Fakultt
   * Berechnung
   * @throws Exception
   */
  public final void testFakultaet() throws Exception
  {
    /*
     * Die Variablen wurden in der setup Methode gesetzt und
     * knnen dort verndert werden
     */
    
    assertEquals(fakErg1,Sinus.fakultaet(fakZahl1));
    
    assertEquals(fakErg2,Sinus.fakultaet(fakZahl2));
    
    /*
     * Ein Sonderfall ist 0! und muss von der Methode erkannt
     * werden.
     * Das Ergebnis muss 1.0 sein, da die Methode ein
     * double zurckliefert (nicht 1). 
     */
    assertEquals(1.0,Sinus.fakultaet(0));
    
    /*
     * Eine negative Fakultt kann nicht berechnet werden und
     * muss von der Methode erkannt werden.
     */
    
    try{
      Sinus.fakultaet(-2);
      fail(this.getName()+" fehlgeschlagen");
    }catch(Exception e){
    	System.out.println("Erfolgreich erkannt ("+this.getName()+"): "+e.getLocalizedMessage());
    }
  }
  
  /**
   * Das Ergebis der Klasse Sinus wird auf korrektheit getestet.
   * Die Eingabedaten werden aus einer Datei gelesen und die
   * Ergebnisse in eine Ausgabedatei geschrieben.
   * Nach dem Berechnungs- und Schreibevorgang wird die
   * Ausgabedatei mit richtigen Ergebissen aus einer Kontrolldatei
   * verglichen.
   * 
   * Es wird vorrausgesetzt, dass die Dateien korrekt mit Inhalt
   * gefllt wurden. Es findet keine Prfung der Dateien statt.
   * 
   * @throws Exception
   */
  public final void testNaeherung() throws Exception 
  {
    //  Beinhaltet jeweils eine Zeile der Datei
    String sZeile = null;
    //  Mit der Variablen kann auf die Datei zugegriffen werden
    Scanner scDatei = null;
    //  Die Ausgabe Datei wird erzeugt
    FileWriter fDatei = null;
    //
    Sinus sin = null;

    
    //  Dem Scanner wird eine Datei zugewiesen und
    //  geprueft ob die Datei existiert
    try
    {
        scDatei = new Scanner( new File( eingabeDatei ) );
    }
    catch ( FileNotFoundException e )
    {
      assertFalse("Datei nicht vorhanden",true);
    }
    
    //  Dem FileWriter wird eine Datei zugewiesen und
    //  geprueft ob die Datei geschrieben werden kann
    try
    {     
        fDatei = new FileWriter( ausgabeDatei );     
    }
    catch ( IOException e )
    {
        assertFalse("Datei kann nicht angelegt oder geaendert werden",true);
    }
    
    
    /*
     * Bei jedem Durchlauf der Schleife wird eine Zeile aus
     * der Eingabedatei gelesen und eine double Zahl generiert.
     * Der Sinus dieser Zahl wird in eine Ausgabedatei geschrieben.
     * Der vorgang stoppt beim Ende einer Datei, oder bei
     * einem Fehler whrend des Durchlaufs.
     */
    do
    {
      sZeile = scDatei.nextLine();
      if (sZeile != null)
        sin = new Sinus(Double.parseDouble(sZeile), iterationsschritte);
      else
        break;
      fDatei.write(sin.getNaeherung() + "\n");
    }
    while (scDatei.hasNextLine());

    // Der Datei verweis wird geschlossen
    scDatei.close();
    fDatei.close();

    // Ausgabe- und Kontrolldatei werden verglichen
    assertTrue(Dateivergleich.compare(ausgabeDatei,kontrollDatei,genauigkeit));
  }
  
  
  public static void main(String args[])
  {
    junit.swingui.TestRunner.run(SinusTest.class);
  }

}
