import junit.framework.TestCase;

public class SinusTest03 extends TestCase {
	//	 Testvariablen fr Fakultt berprfung
	private int fakZahl1;

	private double fakErg1;

	// Testvariablen fr Fakultt berprfung  
	private int fakZahl2;

	private double fakErg2;


	protected void setUp() {
		System.out.println("(1) setUp: " + fakZahl1);

		fakZahl1 = 5;
		fakErg1 = 120;
		fakZahl2 = 0;
		fakErg2 = 1;

		System.out.println("(2) setUp: " + fakZahl1);
	}

	protected void tearDown() {
		fakZahl1 = 0;
		fakErg1 = 0;
		fakZahl2 = 0;
		fakErg2 = 0;
	}

	public final void testFakultaet() throws Exception {
		
		assertEquals(fakErg1, Sinus.fakultaet(fakZahl1));

		assertEquals(fakErg2, Sinus.fakultaet(fakZahl2));

		/*
		 * Ein Sonderfall ist 0! und muss von der Methode erkannt
		 * werden.
		 * Das Ergebnis muss 1.0 sein, da die Methode ein
		 * double zurckliefert (nicht 1). 
		 */
		assertEquals(1.0, Sinus.fakultaet(0));

		try {
			Sinus.fakultaet(-2);
			fail(this.getName() + " fehlgeschlagen");
		} catch (Exception e) {
			System.out.println("Erfolgreich erkannt (" + this.getName() + "): "
					+ e.getLocalizedMessage());
		}
	}

	public final void testImplementierung() throws Exception {

		// Gltige Sinus Konstruktor Aufrufe
		Sinus sin = null;
		assertNull(sin);

		sin = new Sinus(0);
		assertNotNull(sin);
		sin = null;
		assertNull(sin);

		sin = new Sinus(-20, 1);
		assertNotNull(sin);
		sin = null;
		assertNull(sin);

		//  Ungltige Sinus Konstruktor Aufrufe

		/*
		 * Der Funktionswert von 2 und -6 ist nicht zugelassen,
		 * da -6 fr die Iteratioinsschritte steht und diese
		 * grsser als 0 sein mssen 
		 */
		try {
			sin = new Sinus(2, -6);
			assertFalse(this.getName() + " fehlgeschlagen", true);
		} catch (Exception e) {
			System.out.println("Erfolgreich erkannt (" + this.getName() + "): "
					+ e.getLocalizedMessage());
		}

		/*
		 * Der Funktionswert von 30 und 0 ist nicht zugelassen,
		 * da 0 fr die Iteratioinsschritte steht und diese
		 * grsser als 0 sein mssen 
		 */
		try {
			sin = new Sinus(30, 0);
			assertFalse(this.getName() + " fehlgeschlagen", true);
		} catch (Exception e) {
			System.out.println("Erfolgreich erkannt (" + this.getName() + "): "
					+ e.getLocalizedMessage());
		}
	}

	public static void main(String args[]) {
		junit.swingui.TestRunner.run(SinusTest03.class);
	}

}