
public class Bisektion
{
  
  private double    punktA;                        // Linke Intervall Grenze
  private double    punktB;                        // Rechte Intervall Grenze
  private int       sinusSchritte = 10;            // Iterationsschritte fr Sinus-Nherung
  private int       bisektionsSchritte = 10;       // Iterationsschritte fr Bisektionsverfahren
  
  private double    m_Genauigkeit = 0.00000000001; // Genauigkeitsgrenze fr Bisektionsverfahren
  
  
  /**
   * Der Klasse Bisektion werden die Intervallgrenzen bergeben.
   * Die Grenzen drfen nicht identisch sein und mssen der
   * Bedingung f(a)*f(b)<0 gengen.
   * @param a Erste Intervallgrenze
   * @param b Zweite Intervallgrenze
   * @throws Exception tritt auf, falls die Grenzen inicht
   *        erlaubt sind.
   */
  public Bisektion(double a, double b) throws Exception{
    /*
     * Richtige Zuweisung der linken und rechten Grenzen.
     * Sollten die Intervallgrenzen identisch sein, so wird eine
     * Exception geworfen.
     */ 
    if(a < b){
      punktA = a;
      punktB = b;
    }else if(a > b){
      punktA = b;
      punktB = a;
    }else
      throw new Exception("Es muss ein Intervall gegeben sein");
    
    /*
     * Die Funktionswerte a,b mssen der Bedingung
     * f(a)*f(b)<0 
     * gengen, ansonsten wird eine Exception geworfen.
     */ 
    grenzenPruefen();
  }
  
  /**
   * Mit dieser Methode kann die Anzahl an Iterationsschritten 
   * fr das Verfahren der Bisektion vom Benutzer gendert werden. 
   * Die Standardeinstellung betrgt 10.
   * Der angegebene Wert muss grer 0 sein.
   * @param n Anzahl der Iterationsschritte
   * @throws Exception tritt bei ungltiger Anzahl an
   *        Iterationsschritten auf
   */
  public void setBisektionSchritte(int n) throws Exception{
    // Neue Itarationsschritte auf Gltigkeit prfen
    if(n < 1)
      throw new Exception("Schrittgrsse muss >0 sein");
    // Zuweisung der neuen Anzahl an Iterationsschritten
    bisektionsSchritte = n;
  }
  
  /**
   * Mit dieser Methode kann die Anzahl an Iterationsschritten 
   * fr das Verfahren der Sinus-Nherung vom Benutzer gendert 
   * werden. 
   * Die Standardeinstellung betrgt 10.
   * Der angegebene Wert muss grer 0 sein.
   * @param n Anzahl der Iterationsschritte
   * @throws Exception tritt bei ungltiger Anzahl an
   *        Iterationsschritten auf
   */
  public void setSinusSchritte(int n) throws Exception{
    // Neue Itarationsschritte auf Gltigkeit prfen
    if(n < 1)
      throw new Exception("Schrittgrsse muss >0 sein");
    // Zuweisung der neuen Anzahl an Iterationsschritten
    sinusSchritte = n;
  }
  
  /**
   * Die Nullstelle wird mit Hilfe des Bisektions Verfahrens
   * auf eine Maximale Genauigkeit von 0.00000000001
   * berechnet. Whrend der Berechnung wird die Intervallgltigkeit
   * stndig geprft.
   * @return double Liefert die Nullstelle nach der Berechnung 
   * @throws Exception, tritt bei Grenzfehlern auf.
   */
  public double getNullstelle() throws Exception{
    // Intervallmitte fr das Ergebnis initialisieren
    double erg = (punktA+punktB)/2.;
    
    /*
     * Das Bisektionsverfahren wird durch die Iterationsschritte in
     * der Berechnung begrenz. Sollte die Genauigkeit berschritten
     * werden, so wird der Algorithmus unterbrochen.
     */
    for(int n = 0; n < bisektionsSchritte; n++){
      try{
        // Grenzmitte wird in die vorhandenen Grenzen eingepasst
        grenzenAnpassen(erg);
        // Wird die Genauigkeit berschritten
        intervallPruefen();
      }catch (IntervallException e) 
      {
        // Genauigkeit wurde berschritten und dies wird dem Benutzer
        // ber die Konsole kenntlich gemacht
        System.out.println(e.getMessage());
        break;
      }catch (Exception e)
      {
        // Ein Fehler ist whrend der Berechnung aufgetreten
        throw new Exception("a: "+punktA+"\n"+"b: "+punktB+"\n"+e.getMessage());
      }
      // Intervallmitte wird als Ergebnis gespeichert
      erg = (punktA+punktB)/2.;   
    }
    
    return erg;
  }
  
  /**
   * In die zwei bereits vorhandenen Grenzpunkte muss der neue Grenzmittelpunkt
   * so eingepasst werden, dass die Bedingung f(a)*f(b)<0 weiterhin
   * erfllt bleibt. Nach der Methode ist der bergebene Punkt in die Grezpunkte a
   * und b integriert, d.h. einer der beiden wird berschrieben.
   * @param n double Neuer Grenzpunkt
   * @throws Exception Falls bei der Sinus berechnung ein Fehler auftritt
   */
  private void grenzenAnpassen(double n) throws Exception{
    Sinus sinusA = new Sinus(punktA,sinusSchritte); // wird fr den Wert f(a) bentigt
    Sinus neu = new Sinus(n,sinusSchritte);         // Neuer Funktionswert der Mitte
    
    /*
     * Prfen ob PunktA oder PunktB mit dem neuen Grenzpunkt
     * berschrieben werden muss.
     */
    if(sinusA.getNaeherung() <= 0 && neu.getNaeherung() <= 0)
      punktA = n;
    else if(sinusA.getNaeherung() > 0 && neu.getNaeherung() > 0)
      punktA = n;
    else
      punktB = n;
  }
  
  /**
   * Diese Methode prft lediglich, ob die Bedingung
   * f(a)*f(b)<0
   * erfllt ist und wirft bei verletzung dieser BEdingung eine Exception.
   * @throws Exception falls Bedingung nicht erfllt
   */
  private void grenzenPruefen() throws Exception{
    Sinus sinusA = new Sinus(punktA,sinusSchritte); // Funktionswert linke Grenze
    Sinus sinusB = new Sinus(punktB,sinusSchritte); // Funktionswert rechte Grenze
    /*
     * Sind die Funktionswerte der Grenzen beide Positiv oder beide Negativ,
     * so ist die Bedingung verletzt und fhrt zum wurf einer Exception.
     * Eine Nullstelle kann somit nicht genau bestimmt werden.
     */
    if((sinusA.getNaeherung() > 0 && sinusB.getNaeherung() > 0) || (sinusA.getNaeherung() < 0 && sinusB.getNaeherung() < 0))
      throw new Exception("Funktionswerte sind beide entwerde positiv oder negativ");
  }
  
  /**
   * Sollte die rechte und linke Grenze zu nahe beieinander liegen, so wird
   * das Bisektionsverfahren abgebrochen.
   * Eine Genauigkeitsgrenze ist als member-Variable gespeichert und wird als
   * Messgrad verwendet.
   * @throws IntervallException falls der Abstand der Grenzen berschritten wurde
   */
  private void intervallPruefen() throws IntervallException{
    // Der Abstand zwischen a und b wird gemessen und mit der
    // Genauigkeits-Variablen verglichen
    if(Math.abs(punktA-punktB)<m_Genauigkeit)
      throw new IntervallException("Nullstelle mit der Genauigkeit von 0.00000000001 entdeckt");
  }
  
  
}
