import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;

import junit.framework.TestCase;

public class BisektionTest extends TestCase
{
  // Datei Pfade fr Eingabe, Ausgabe und Kontrolle
  private String eingabeDatei = null;
  private String ausgabeDatei = null;
  private String kontrollDatei = null;
  
  // Genauigkeitsvariablen fr Datei vergleich  
  private int genauigkeit;
  
  // Genauigkeitsvariable fr Bisektion berechnung  
  private int iterationsschritteBisektion;
  
  // Genauigkeitsvariable fr Sinus berechnung   
  private int iterationsschritteSinus;
  
  
  /**
   * Folgende Variablen werden gesetzt:
   * 
   * Dateipfad
   * Genauigkeit fr Dateivergleich
   * Iterationsschritte fr Sinus berechnung
   * Iterationsschritte fr Bisektion berechnung
   */
//-----------------------------------------------------------------------------setUp 
  protected void setUp()
  {   
    eingabeDatei = "Nullstellen//eingabe.txt";
    ausgabeDatei = "Nullstellen//ausgabe.txt";
    kontrollDatei = "Nullstellen//kontrolle.txt";
    
    genauigkeit = 7;
    iterationsschritteBisektion = 50;
    iterationsschritteSinus = 50;
  }
 
  //-----------------------------------------------------------------------------tearDown
  protected void tearDown()
  {
    eingabeDatei = null;
    ausgabeDatei = null;
    kontrollDatei = null;
  }
  
  /**
   * Mehrere Bisektion konstruktor Aufrufe werden getestet.
   * @throws Exception
   */
  public final void testImplementierung() throws Exception
  {

    //  Gltige Bisektion Konstruktor Aufrufe
    
    /*
     * Je ein Funktionswert liegt im positiven und einer
     * im negativen Sinusbereich 
     */
    Bisektion nst = null;
    assertNull(nst);
    
    nst = new Bisektion(0,4);
    assertNotNull(nst);
    nst = null;
    
    nst = new Bisektion(-4,0);
    assertNotNull(nst);
    nst = null;

    //  Ungltige Sinus Konstruktor Aufrufe
    
    /*
     * Da die Funktionswerte bei -1 und 4 der Sinuskurve
     * negativ sind, schlgt das Bisektionsverfahren fehl.
     */
    try{
      nst = new Bisektion(-1,4);
      fail(this.getName()+" fehlgeschlagen");
    }catch(Exception e){
      System.out.println("Erfolgreich erkannt ("+this.getName()+"): "+e.getLocalizedMessage());
    }
    
    /*
     * Da die Funktionswerte bei 1 und 3 der Sinuskurve
     * positiv sind, schlgt das Bisektionsverfahren fehl.
     */
    try{
      nst = new Bisektion(1,3);
      fail(this.getName()+" fehlgeschlagen");
    }catch(Exception e){
      System.out.println("Erfolgreich erkannt ("+this.getName()+"): "+e.getLocalizedMessage());
    }
  }
  
  /**
   * Diese Methode prft, ob die Methode SetSinusSchritte
   * richtig funktioniert
   * 
   * @throws Exception
   */
  public final void testSetSinusSchritte() throws Exception
  {
    // Initialisierung mit richtigen Werten
    Bisektion nst = new Bisektion(-1,1);
    
    // Diese bergabe sollte funktionieren
    nst.setSinusSchritte(5);
    nst.setSinusSchritte(50);
    
    // Diese bergabe sollte nicht funktionieren
    try{
      nst.setSinusSchritte(0);
      throw new Exception("Nicht erfolgreich erkannt ("+this.getName());
    }catch(Exception e)
    {
      System.out.println("Erfolgreich erkannt ("+this.getName()+"): "+e.getLocalizedMessage());
    }
    
    //  Diese bergabe sollte nicht funktionieren
    try{
      nst.setSinusSchritte(-5);
      throw new Exception("Nicht erfolgreich erkannt ("+this.getName());
    }catch(Exception e)
    {
      System.out.println("Erfolgreich erkannt ("+this.getName()+"): "+e.getLocalizedMessage());
    }  
  }
  
  /**
   * Diese Methode prft, ob die Methode SetBisektionSchritte
   * richtig funktioniert
   * 
   * @throws Exception
   */
  public final void testSetBisektionSchritte() throws Exception
  {
    // Initialisierung mit richtigen Werten
    Bisektion nst = new Bisektion(-1,1);
    
    // Diese bergabe sollte funktionieren
    nst.setBisektionSchritte(5);
    nst.setBisektionSchritte(50);
    
    // Diese bergabe sollte nicht funktionieren
    try{
      nst.setBisektionSchritte(0);
      fail("Nicht erfolgreich erkannt ("+this.getName());
    }catch(Exception e)
    {
      System.out.println("Erfolgreich erkannt ("+this.getName()+"): "+e.getLocalizedMessage());
    }
    
    //  Diese bergabe sollte nicht funktionieren
    try{
      nst.setBisektionSchritte(-5);
      fail("Nicht erfolgreich erkannt ("+this.getName());
    }catch(Exception e)
    {
      System.out.println("Erfolgreich erkannt ("+this.getName()+"): "+e.getLocalizedMessage());
    }  
  }
  
  /**
   * Das Ergebis der Klasse Bisektion wird auf korrektheit getestet.
   * Die Eingabedaten werden aus einer Datei gelesen und die
   * Ergebnisse in eine Ausgabedatei geschrieben.
   * Nach dem Berechnungs- und Schreibevorgang wird die
   * Ausgabedatei mit richtigen Ergebissen aus einer Kontrolldatei
   * verglichen.
   * 
   * Es wird vorrausgesetzt, dass die Dateien korrekt mit Inhalt
   * gefllt wurden. Es findet keine Prfung der Dateien statt.
   * 
   * @throws Exception
   */
  public final void testNullstellenBerechnung() throws NumberFormatException, Exception
  {
    //  Beinhaltet jeweils eine Zeile der Datei
    double sZeile1 ;
    //  Beinhaltet jeweils eine Zeile der Datei
    double sZeile2 ;
    //  Mit der Variablen kann auf die Datei zugegriffen werden
    Scanner scDatei = null;
    //  Die Ausgabe Datei wird erzeugt
    FileWriter fDatei = null;
    //
    Bisektion nst = null;

    
    //  Dem Scanner wird eine Datei zugewiesen und
    //  geprueft ob die Datei existiert
    try
    {
        scDatei = new Scanner( new File( eingabeDatei ) );
    }
    catch ( FileNotFoundException e )
    {
      fail("Datei nicht vorhanden");
    }
    
    //  Dem FileWriter wird eine Datei zugewiesen und
    //  geprueft ob die Datei geschrieben werden kann
    try
    {     
        fDatei = new FileWriter( ausgabeDatei );     
    }
    catch ( IOException e )
    {
      fail("Datei kann nicht angelegt oder geaendert werden");
    }
    
    /*
     * Bei jedem Durchlauf der Schleife werden zwei Zeilen aus
     * der Eingabedatei gelesen und double Zahlen generiert.
     * Die Berechnete Nullstelle wird in eine Ausgabedatei geschrieben.
     * Der Vorgang stoppt beim Ende einer Datei, oder bei
     * einem Fehler whrend des Durchlaufs.
     */
  
    do
    {
      // 2 Zeilen lesen und double Zahl generieren
      sZeile1 = scDatei.nextDouble();
      sZeile2 = scDatei.nextDouble();

      // Bisektion wird initialisiert
      nst = new Bisektion(sZeile1, sZeile2);
      // Sinus iterationsschritte wird gesetzt
      nst.setSinusSchritte(iterationsschritteSinus);
      // Bisektion iterationsschritte wird gesetzt
      nst.setBisektionSchritte(iterationsschritteBisektion);

      // Ergebnis wird in Datei geschrieben
      fDatei.write(nst.getNullstelle() + "\n");
    }
    while (scDatei.hasNextLine());

    // Der Datei verweis wird geschlossen
    scDatei.close();
    fDatei.close();
  
    // Ausgabe- und Kontrolldatei werden verglichen    
    assertTrue(Dateivergleich.compare(ausgabeDatei,kontrollDatei,genauigkeit));
  }
  
  public static void testNstBerechnung() throws Exception
  {
	  Bisektion bisektion = new Bisektion(-1,1);
	  
	  assertNotNull(bisektion);
	  
	  bisektion.setBisektionSchritte(50);
	  bisektion.setSinusSchritte(50);
	  
	  //assertEquals(0, bisektion.getNullstelle(),0.00000000001);
	  
	  assertEquals(0, bisektion.getNullstelle());
  }
  
  
  public static void main(String args[])
  {
    junit.swingui.TestRunner.run(BisektionTest.class);
  }
  
}

