
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

public class Dateivergleich
{

  
  /**
   * 2 Dateien werden miteinander verglichen.
   * Es wird davon ausgegangen, dass die Dateien eine spezielle Norm
   * einhalten, dies wird nicht berprft.
   * Die Datei beinhaltet nur Zahlen.
   * In jeder Zeile steht maximal eine Zahl
   * Die Datei beinhaltet keine Leerzeilen.
   * Die Datei beginnt am Anfang.
   * In der letzten Zeile der Datei steht nichts.
   * 
   * @param ergebnisDatei String
   * @param kontrollDatei String
   * @param genauigkeit int
   * @return boolean
   * @throws Exception
   */
  public static boolean compare(String ergebnisDatei, String kontrollDatei, int genauigkeit) throws Exception
  {
    //  Datei Handle fr Ergebnis- und Kontrolldatei
    Scanner ergebnisDateiStream = null;
    Scanner kontrollDateiStream = null; 

    // Strings enthalten jeweils eine Zeile der jeweiligen Datei
    String zeileErgebnisDatei = "";
    String zeileKontrollDatei = "";
 
    // Sind die Dateien gleich
    boolean bDatenSindGleich = true;
    
    // Die Dateien werden geffnet
    try 
    {
      kontrollDateiStream = new Scanner(new File(kontrollDatei));
      ergebnisDateiStream = new Scanner(new File(ergebnisDatei));
    } 
    catch (FileNotFoundException e) 
    {
      throw new Exception("IOException: TestBase.compare");
    }
    
    /*
     * Solange keine der beiden Dateien am Ende angelangt ist,
     * wird jede Zeile der einen Datei mit der passenden Zeile
     * der anderen Datei verglichen
     */ 
    do{
      // Jeweils eine Zeile einlesen
      zeileErgebnisDatei = ergebnisDateiStream.nextLine();
      zeileKontrollDatei = kontrollDateiStream.nextLine();
      
      // Sollten die Zeilen voneinander abweichen sind sie nicht gleich
      // und die Schleife wird abgebrochen
      if(!zeilenVergleich(zeileErgebnisDatei,zeileKontrollDatei,genauigkeit))
      {  
        bDatenSindGleich = false;
        break;
      }
      
    }while(kontrollDateiStream.hasNextLine() && ergebnisDateiStream.hasNextLine());
    
    /*
     * Sollte eine Datei am Ende angelangt sein, die andere Datei jedoch
     * noch Elemente entahlten, so sind sie unterschiedlich Lang und
     * entsprechen nicht den Vorgaben.
     * Es wird dabei von nicht Gleichheit ausgegangen 
     */
    if(kontrollDateiStream.hasNextLine() || ergebnisDateiStream.hasNextLine())
      bDatenSindGleich = false;
    

    // Dateien werden geschlossen
    kontrollDateiStream.close();
    ergebnisDateiStream.close();
     
    //Ergenis wird zurckgeliefert
    return bDatenSindGleich;
  }
  
  /**
   * Diese Methode berprft 2 Zeilen auf Gleichheit
   * @param a String
   * @param b String
   * @param genauigkeit int Anzahl der Stellen
   * @return
   */
  protected static boolean zeilenVergleich(String a, String b, int genauigkeit)
  {
    // Sind die Zeilen gleich
    boolean stringGleich = true;

    /*
     * Sollte die Zahl in einer der beiden Zeilen weniger Stellen haben, als
     * die angegebene Genauigkeitsvorgabe, so muss die Genauigkeitsvorgabe
     * angepasst werden.
     */
    if(a.length()==b.length() && a.length()<genauigkeit)
      genauigkeit = a.length()-1;

    // Anhand der Genauigkeit werden die Zahlen verglichen
    for(int n = 0; n<genauigkeit+1;n++)
    {
      // Ist ein Zeichenpaar ungleich, so sind die Zeilen nciht identisch
      if(a.charAt(n)!=b.charAt(n))
      {
        stringGleich = false;
        break;
      }    
    }
    
    // Das Ergebnis wird zurckgeliefert
    return stringGleich;
  }
}
