package barrier;

import java.util.concurrent.CyclicBarrier;

public class MyRunnable implements Runnable {

	// number of iterations for each thread
	private int number;

	// barrier for synchronisation
	private CyclicBarrier b;

	public MyRunnable(int num, CyclicBarrier b) {
		this.number = num;
		this.b = b;
	}

	@Override
	public void run() {
		// Thread needs something to do
		for (int i = 0; i < number; i++) {
			Math.pow(Math.log(i), i);
		}

		System.out.println("Thread " + Thread.currentThread().getId()
				+ " finished.");

		try {
			b.await();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
