package pipe;

import java.util.concurrent.LinkedBlockingQueue;

public class MyRunnableProducer implements Runnable {

	private LinkedBlockingQueue<Integer> pipe;
	private final int maxIterations;

	public MyRunnableProducer(LinkedBlockingQueue<Integer> pipe,
			int maxIterations) {
		this.pipe = pipe;
		this.maxIterations = maxIterations;
	}

	@Override
	public void run() {
		for (int i = 0; i < this.maxIterations; i++) {
			try {
				Thread.sleep(1000);
				System.out.println("Put " + i + " into pipe.");
				pipe.put(i);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}
