package threadPool.futures;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Starter {
	public static void main(String[] args) throws Exception {
		// numbers to check
		int[] numbers = { 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
				17, 18, 19, 20, 21, 22, 23 };

		// create threadpool
		ExecutorService pool = Executors.newFixedThreadPool(5);

		// create list of futures
		ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();

		// submit tasks to threadpool
		for (int i = 0; i < numbers.length; i++) {
			futures.add(pool.submit(new MyCallable(numbers[i])));
		}

		// fetch results from future list
		for (int i = 0; i < numbers.length; i++) {
			System.out.println("" + numbers[i] + " is"
					+ (futures.get(i).get() ? "" : " not") + " prime");
		}

		pool.shutdown();
	}
}
