package endingThreads;

public class Starter {

	static final int numThreads = 5;

	public static void main(String[] args) throws Exception {

		Thread[] threads = new Thread[numThreads];

		/*
		 * Create and start several threads; outputs are parallel.
		 */

		for (int i = 0; i < numThreads; i++) {
			threads[i] = new Thread(new MyRunnable());
			threads[i].start();
		}

		System.out.println("PI = " + myVeryImportantFunction(10000));

		for (int i = 0; i < numThreads; i++) {
			threads[i].join(); // wait for thread i to finish
			System.out.println("Thread " + i + " finished.");
		}
	}

	private static double myVeryImportantFunction(int iterations) {
		double PI = 0;
		
		int vorzeichen = 1;
		for (int i = 1; i <= iterations * 2; i += 2) {
			PI += vorzeichen * (1. / i);
			vorzeichen *= -1;
		}
		
		return 4 * PI;
	}
}
