package atomicDatatypes;

import java.util.concurrent.atomic.AtomicInteger;

public class AtomicDatatypes {
	public static AtomicInteger x;
	private static final int numThreads = 5;
	private static final int numIterations = 10;

	/* No Race Conditions since Atomic Datatypes are used */
	public static void main(String[] args) {
		Thread[] threads = new Thread[numThreads];
		long t, avgTime = 0;

		for (int i = 0; i < 10; i++) {
			t = System.nanoTime();

			/* Reset variable x */
			AtomicDatatypes.x = new AtomicInteger(0);

			/* Create and start threads */
			for (int j = 0; j < numThreads; j++) {
				threads[j] = new Thread(new MyRunnable());
				threads[j].start();
			}

			/* Wait until all threads are finished */
			try {
				for (int j = 0; j < numThreads; j++) {
					threads[j].join();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

			/* print values of x */
			t = (System.nanoTime() - t) / 1000000;
			System.out.println("Value: " + AtomicDatatypes.x.get() + ", Time: "
					+ t + " ms");
			avgTime += t;
		}

		System.out.println("Average time: " + avgTime / numIterations + " ms");
	}
}
