package mutexLock.reentrantLock;

import java.util.concurrent.locks.ReentrantLock;

public class ReentrantLockStarter {
	public static int x;
	private static final int numThreads = 5;
	private static final int numIterations = 10;

	public static void main(String[] args) {
		method1();
		method2();
	}

	/*
	 * No Race Condition despite use of primitive datatypes. Attention: Threads
	 * are running in parallel, but wait for each other -> serialization
	 */
	public static void method1() {
		Thread[] threads = new Thread[numThreads];
		ReentrantLock mutex = new ReentrantLock(); // some arbitraty object as
													// lock
		long t, avgTime = 0;

		for (int i = 0; i < numIterations; i++) {
			t = System.nanoTime();
			/* Reset x */
			ReentrantLockStarter.x = 0;

			/* Create and start threads */
			for (int j = 0; j < numThreads; j++) {
				threads[j] = new Thread(new MyRunnable(mutex));
				threads[j].start();
			}

			/* Wait for threads to finish */
			try {
				for (int j = 0; j < numThreads; j++) {
					threads[j].join();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

			/* print values of x */
			t = (System.nanoTime() - t) / 1000000;
			System.out.println("Value: " + ReentrantLockStarter.x + ", Time: "
					+ t + " ms");
			avgTime += t;
		}

		System.out.println("Average time: " + avgTime / numIterations + " ms");
	}

	/*
	 * No Race Condition despite use of primitive data types. Attention: Threads
	 * are running in parallel, but wait for each other -> serialization
	 * Additionally increasing overhead because of frequently acquiring and
	 * releasing the lock
	 */
	public static void method2() {
		Thread[] threads = new Thread[numThreads];
		ReentrantLock mutex = new ReentrantLock(); // some arbitraty object as
													// lock
		long t, avgTime = 0;

		for (int i = 0; i < numIterations; i++) {
			t = System.nanoTime();
			/* Reset x */
			ReentrantLockStarter.x = 0;

			/* Create and start threads */
			for (int j = 0; j < numThreads; j++) {
				threads[j] = new Thread(new MyRunnable2(mutex));
				threads[j].start();
			}

			/* Wait for threads to finish */
			try {
				for (int j = 0; j < numThreads; j++) {
					threads[j].join();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

			/* print values of x */
			t = (System.nanoTime() - t) / 1000000;
			System.out.println("Value: " + ReentrantLockStarter.x + ", Time: "
					+ t + " ms");
			avgTime += t;
		}

		System.out.println("Average time: " + avgTime / numIterations + " ms");
	}
}
