package withoutSynchronisation;

public class WithoutSynchronisation {
	public static int x;
	private static final int numThreads = 5;
	private static final int numIterations = 10;

	/*
	 * Race conditions, since primitive datatypes are used.
	 */
	public static void main(String[] args) {
		Thread[] threads = new Thread[numThreads];
		long t, avgTime = 0;

		for (int i = 0; i < numIterations; i++) {
			t = System.nanoTime();

			/* Reset variable x */
			WithoutSynchronisation.x = 0;

			/* Create and start new threads */
			for (int j = 0; j < numThreads; j++) {
				threads[j] = new Thread(new MyRunnable());
				threads[j].start();
			}

			/* Wait for threads to finish */
			try {
				for (int j = 0; j < numThreads; j++) {
					threads[j].join();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

			/* print values of x */
			t = (System.nanoTime() - t) / 1000000;
			System.out.println("Value: " + WithoutSynchronisation.x + ", Time: " + t + " ms");
			avgTime += t;
		}
		
		System.out.println("Average time: " + avgTime / numIterations + " ms");
	}
}