package barrier;

import java.util.concurrent.CyclicBarrier;

public class Starter {
	private static final int numThreads = 5;

	public static void main(String[] args) {
		CyclicBarrier b = new CyclicBarrier(numThreads + 1);

		for (int i = 0; i < numThreads; i++) {
			new Thread(new MyRunnable((int) Math.pow(i*15, i), b)).start();
		}

		try {
			b.await();
		} catch (Exception e) {
			e.printStackTrace();
		}

		System.out.println("All threads finished");
	}
}
