#include <time.h>
#include <stdlib.h>
#include <stdio.h>

/*
 * gcc -std=c99 -g -O3 -fopenmp -o find_maximum find_maximum.c
 * OMP_NUM_THREADS=5 ./find_maximum
 */

void initialize_array(int*, const int);
void print_array(int*, const int);

int main(int argc, char** argv)
{
	srand(0);

	const int n = 100;
	int* arr = (int*) malloc(sizeof(int) * n);

	initialize_array(arr, n);
	print_array(arr, n);

	int max = 0;

	for(int i = 0; i < n; i++)
	{
		if(arr[i] > max)
		{
			max = arr[i];
		}
	}

	printf("The maximum was: %d\n", max);

	return EXIT_SUCCESS;
}

void initialize_array(int *arr, const int n)
{
	for(int i = 0; i < n; i++)
	{
		arr[i] = rand();
	}
}

void print_array(int *arr, const int n)
{
	printf("(");

	for(int i = 0; i < (n - 1); i++)
	{
		printf("%d, ", arr[i]);
	}

	printf("%d)\n", arr[n-1]);
}