#include <time.h>
#include <stdlib.h>
#include <stdio.h>

/*
 * gcc -std=c99 -g -O3 -fopenmp -o search_for_number search_for_number.c
 * OMP_NUM_THREADS=5 ./search_for_number
 */

void initialize_array(int*, const int);
void print_array(int*, const int);

const int maxValue = 10;
const int n = 100;

int main(int argc, char** argv)
{
	srand(0);

	//arra
	int arr[n];
	int arrCount[maxValue];

	initialize_array(arr, n);
	print_array(arr, n);

	//initialize the counter array
	for(int i = 0; i < maxValue ; i++)
	{
		arrCount[i] = 0;
	}

	for(int i = 0; i < maxValue; i++)
	{
		for(int j = 0; j < n; j++)
		{
			if(arr[j] == i)
			{
				arrCount[i]++;
			}
		}
	}

	//print out the counter array
	for(int i = 0; i < maxValue ; i++)
	{
		printf("%d was found %d times\n", i, arrCount[i]);
	}

	return EXIT_SUCCESS;
}

void initialize_array(int *arr, const int n)
{
	for(int i = 0; i < n; i++)
	{
		arr[i] = rand() % maxValue;
	}
}

void print_array(int *arr, const int n)
{
	printf("(");

	for(int i = 0; i < (n - 1); i++)
	{
		printf("%d, ", arr[i]);
	}

	printf("%d)\n", arr[n-1]);
}