/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class Main
extends Shell {
    private static Main instance;
    private Text playerIterations;
    private Text playerDuration;
    private Text editorX;
    private Text editorY;
    private Slider playerSlider;
    private Composite playerComposite;
    private Composite editorComposite;
    private Field playerField;
    private Field editorField;
    private Button playerPlayPause;
    private Button playerStop;
    private Menu actualMenu;
    private Timer t;
    private String filename = "";
    private ArrayList<String> storage;
    private int drawingMode = 0;
    private static final int NOPAINT = 0;
    private static final int PAINT = 1;
    private static final int ERASE = 2;

    public static void main(String[] args) {
        try {
            Display display = Display.getDefault();
            Main shell = new Main(display);
            shell.open();
            shell.layout();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Main(Display display) {
        super(display, 1264);
        this.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                if (Main.this.t != null) {
                    Main.this.t.cancel();
                    Main.this.t.purge();
                    Main.this.t = null;
                }
            }
        });
        this.createContents();
        instance = this;
    }

    public void loadFileForPlayer(String file) {
        if (this.t != null) {
            this.t.cancel();
            this.t.purge();
            this.t = null;
        }
        try {
            Scanner sc = new Scanner(new File(file));
            this.storage = new ArrayList();
            while (sc.hasNextLine()) {
                this.storage.add(sc.nextLine());
            }
            sc.close();
            this.filename = file.substring(file.lastIndexOf(92) + 1);
            this.playerIterations.setText("" + this.storage.size());
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this, 33);
            mb.setText("Error");
            mb.setMessage("Error while loading file.");
            mb.open();
        }
    }

    protected void createContents() {
        this.setText("Game Of Life");
        this.setSize(668, 502);
        this.setLayout(new FillLayout());
        final TabFolder tabFolder = new TabFolder(this, 0);
        TabItem tabItem_1 = new TabItem(tabFolder, 0);
        tabItem_1.setText("Player");
        TabItem tabItem_2 = new TabItem(tabFolder, 0);
        tabItem_2.setText("Editor");
        tabFolder.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (tabFolder.getSelectionIndex() == 0) {
                    Main.getInstance().createMenuPlayer();
                } else if (tabFolder.getSelectionIndex() == 1) {
                    Main.getInstance().createMenuEditor();
                } else {
                    System.out.println("Else");
                }
            }
        });
        Composite framePlayer = new Composite(tabFolder, 0);
        framePlayer.setLayout(new GridLayout(3, true));
        Composite frameEditor = new Composite(tabFolder, 0);
        frameEditor.setLayout(new GridLayout(2, false));
        tabItem_1.setControl(framePlayer);
        tabItem_2.setControl(frameEditor);
        this.playerComposite = new Composite(framePlayer, 2048);
        this.playerComposite.setBackground(SWTResourceManager.getColor(1));
        GridLayout gl_outerComposite = new GridLayout(1, false);
        gl_outerComposite.verticalSpacing = 0;
        gl_outerComposite.horizontalSpacing = 0;
        gl_outerComposite.marginHeight = 0;
        gl_outerComposite.marginWidth = 0;
        this.playerComposite.setLayout(gl_outerComposite);
        this.playerComposite.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        Label labelNumberOfIterations = new Label(framePlayer, 0);
        labelNumberOfIterations.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        labelNumberOfIterations.setText("Number of iterations:");
        this.playerIterations = new Text(framePlayer, 2048);
        this.playerIterations.setEnabled(false);
        this.playerIterations.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        new Label(framePlayer, 0);
        Label labelFrameDuration = new Label(framePlayer, 0);
        labelFrameDuration.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        labelFrameDuration.setText("Frame duration:");
        this.playerDuration = new Text(framePlayer, 2048);
        this.playerDuration.setText("500");
        this.playerDuration.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        Label labelMs = new Label(framePlayer, 0);
        labelMs.setText("ms");
        this.playerPlayPause = new Button(framePlayer, 0);
        this.playerPlayPause.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (Main.this.t != null) {
                    Main.this.t.cancel();
                    Main.this.t.purge();
                    Main.this.t = null;
                } else if (Main.this.storage != null && Main.this.storage.size() > 0) {
                    Main.this.playerStop.setEnabled(true);
                    Main.this.t = new Timer();
                    Main.this.t.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            Main.getInstance().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    int selection = Main.this.playerSlider.getSelection() + Main.this.playerSlider.getThumb();
                                    if (selection < Main.this.playerSlider.getMaximum()) {
                                        Main.this.playerSlider.setSelection(selection);
                                        Main.this.drawFieldPlayer(selection, Main.this.playerField);
                                    } else {
                                        Main.this.playerSlider.setSelection(0);
                                        Main.this.t.cancel();
                                        Main.this.t.purge();
                                        Main.this.t = null;
                                    }
                                }
                            });
                        }
                    }, Integer.parseInt(Main.this.playerDuration.getText()), (long)Integer.parseInt(Main.this.playerDuration.getText()));
                }
            }
        });
        this.playerPlayPause.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.playerPlayPause.setText("Play / Pause");
        this.playerStop = new Button(framePlayer, 0);
        this.playerStop.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (Main.this.storage != null && Main.this.storage.size() > 0) {
                    if (Main.this.t != null) {
                        Main.this.t.cancel();
                        Main.this.t.purge();
                        Main.this.t = null;
                    }
                    Main.getInstance().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Main.this.playerSlider.setSelection(0);
                            Main.this.drawFieldPlayer(Main.this.playerSlider.getSelection(), Main.this.playerField);
                        }
                    });
                }
            }
        });
        this.playerStop.setLayoutData(new GridData(4, 4, false, false, 1, 1));
        this.playerStop.setText("Stop");
        this.playerSlider = new Slider(framePlayer, 0);
        this.playerSlider.setEnabled(false);
        this.playerSlider.setMaximum(0);
        this.playerSlider.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Main.this.drawFieldPlayer(Main.this.playerSlider.getSelection(), Main.this.playerField);
            }
        });
        this.playerSlider.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.createMenuPlayer();
        this.editorComposite = new Composite(frameEditor, 2048);
        this.editorComposite.setBackground(SWTResourceManager.getColor(1));
        GridLayout gl_outerCompositeEditor = new GridLayout(1, false);
        gl_outerCompositeEditor.verticalSpacing = 0;
        gl_outerCompositeEditor.horizontalSpacing = 0;
        gl_outerCompositeEditor.marginHeight = 0;
        gl_outerCompositeEditor.marginWidth = 0;
        this.editorComposite.setLayout(gl_outerCompositeEditor);
        this.editorComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        Label lblDimensionX = new Label(frameEditor, 0);
        lblDimensionX.setText("Columns");
        this.editorX = new Text(frameEditor, 2048);
        this.editorX.setText("10");
        this.editorX.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblDimensionY = new Label(frameEditor, 0);
        lblDimensionY.setText("Rows:");
        this.editorY = new Text(frameEditor, 2048);
        this.editorY.setText("10");
        this.editorY.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        Button create = new Button(frameEditor, 0);
        create.setLayoutData(new GridData(4, 0x1000000, false, false, 2, 1));
        create.setText("Create");
        create.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (Main.this.editorField != null) {
                    Main.this.editorField.dispose();
                }
                int cols = Integer.parseInt(Main.this.editorX.getText());
                int rows = Integer.parseInt(Main.this.editorY.getText());
                Main.this.editorField = new Field(Main.getInstance(), 0);
                Main.this.editorField.updateField(Main.this.createEmptyField(cols, rows));
                Main.this.createField(Main.this.editorComposite, Integer.parseInt(Main.this.editorY.getText()), Integer.parseInt(Main.this.editorX.getText()), false, null);
            }
        });
        this.addControlListener(new ControlListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void controlResized(ControlEvent e) {
                Main main = Main.getInstance();
                synchronized (main) {
                    if (Main.this.playerField != null) {
                        Main.getInstance().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Main.this.playerField.updateField();
                            }
                        });
                    }
                    if (Main.this.editorField != null) {
                        Main.getInstance().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Main.this.editorField.updateField();
                            }
                        });
                    }
                }
            }

            @Override
            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void createMenuPlayer() {
        if (this.actualMenu != null) {
            this.actualMenu.dispose();
        }
        this.actualMenu = new Menu(this, 2);
        this.setMenuBar(this.actualMenu);
        MenuItem menuItemFile_1 = new MenuItem(this.actualMenu, 64);
        menuItemFile_1.setText("File");
        Menu menu_1 = new Menu(menuItemFile_1);
        menuItemFile_1.setMenu(menu_1);
        MenuItem menuItemLoad = new MenuItem(menu_1, 0);
        menuItemLoad.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Main.getInstance(), 4096);
                fd.setText("Open");
                fd.setFilterPath("C:/_maastricht/");
                String[] filterExt = new String[]{"*.gol"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null && !selected.equals("")) {
                    Main.getInstance().loadFileForPlayer(selected);
                    Main.getInstance().createField(Main.this.playerComposite, -1, -1, true, null);
                }
            }
        });
        menuItemLoad.setText("Load");
        new MenuItem(menu_1, 2);
        MenuItem menuItemClose = new MenuItem(menu_1, 0);
        menuItemClose.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                System.exit(0);
            }
        });
        menuItemClose.setText("Close");
    }

    private void createMenuEditor() {
        if (this.actualMenu != null) {
            this.actualMenu.dispose();
        }
        this.actualMenu = new Menu(this, 2);
        this.setMenuBar(this.actualMenu);
        MenuItem menuItemFile_1 = new MenuItem(this.actualMenu, 64);
        menuItemFile_1.setText("File");
        Menu menu_1 = new Menu(menuItemFile_1);
        menuItemFile_1.setMenu(menu_1);
        MenuItem menuItemLoad = new MenuItem(menu_1, 0);
        menuItemLoad.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Main.getInstance(), 4096);
                fd.setText("Open");
                fd.setFilterPath("C:/_maastricht/");
                String[] filterExt = new String[]{"*.gol"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null && !selected.equals("")) {
                    Main.getInstance().loadFileForEditor(selected);
                }
            }
        });
        menuItemLoad.setText("Load");
        MenuItem menuItemSave = new MenuItem(menu_1, 0);
        menuItemSave.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Main.getInstance(), 8192);
                fd.setText("SAVE");
                fd.setFilterPath("C:/_maastricht/");
                String[] filterExt = new String[]{"*.gol"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null && !selected.equals("")) {
                    Main.getInstance().saveFileFromEditor(selected);
                }
            }
        });
        menuItemSave.setText("Save");
        new MenuItem(menu_1, 2);
        MenuItem menuItemClose = new MenuItem(menu_1, 0);
        menuItemClose.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                System.exit(0);
            }
        });
        menuItemClose.setText("Close");
    }

    private void loadFileForEditor(String file) {
        try {
            Scanner sc = new Scanner(new File(file));
            String field = null;
            if (sc.hasNextLine()) {
                field = sc.nextLine();
            }
            sc.close();
            this.createField(this.editorComposite, -1, -1, false, field);
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this, 33);
            mb.setText("Error");
            mb.setMessage("Error while loading file.");
            mb.open();
        }
    }

    private void saveFileFromEditor(String file) {
        File f = new File(file);
        if (f.exists()) {
            MessageBox m = new MessageBox(this, 196);
            m.setMessage("File exists. Overwrite?");
            m.setText("File exists");
            int r = m.open();
            if (r == 128) {
                return;
            }
        }
        try {
            PrintWriter pw = new PrintWriter(new File(file));
            pw.print(this.editorField.getString());
            pw.close();
        }
        catch (IOException e) {
            MessageBox mb = new MessageBox(this, 33);
            mb.setText("Error");
            mb.setMessage("Error while writing file.");
            mb.open();
        }
    }

    private void createField(Composite cmp, int numRows, int numCols, boolean player, String field) {
        if (player) {
            if (this.playerField != null) {
                this.playerField.dispose();
            }
            this.playerField = new Field(cmp, 0x20000000);
            this.playerField.setLayoutData(new GridData(4, 4, true, true, 1, 1));
            this.createMenuPlayer();
            this.drawFieldPlayer(0, this.playerField);
            this.playerSlider.setMinimum(0);
            this.playerSlider.setMaximum(this.storage.size());
            this.playerSlider.setSelection(0);
            this.playerSlider.setPageIncrement(1);
            this.playerSlider.setIncrement(1);
            this.playerSlider.setThumb(1);
            this.playerSlider.setEnabled(true);
        } else {
            if (this.editorField != null) {
                this.editorField.dispose();
            }
            this.editorField = new Field(cmp, 0x20000000);
            this.editorField.setLayoutData(new GridData(4, 4, true, true, 1, 1));
            if (field == null) {
                this.editorField.updateField(this.createEmptyField(numCols, numRows));
            } else {
                this.editorField.updateField(field);
            }
            this.editorField.addMouseListener(new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseDown(MouseEvent e) {
                    super.mouseDown(e);
                    if (e.button == 1) {
                        Field field = Main.this.editorField;
                        synchronized (field) {
                            Main.this.drawingMode = 1;
                        }
                        Main.this.editorField.setActive(true, new Point(e.x, e.y));
                    } else if (e.button == 3) {
                        Field field = Main.this.editorField;
                        synchronized (field) {
                            Main.this.drawingMode = 2;
                        }
                        Main.this.editorField.setActive(false, new Point(e.x, e.y));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseUp(MouseEvent e) {
                    super.mouseUp(e);
                    Field field = Main.this.editorField;
                    synchronized (field) {
                        Main.this.drawingMode = 0;
                    }
                }
            });
            this.editorField.addMouseMoveListener(new MouseMoveListener(){

                @Override
                public void mouseMove(MouseEvent e) {
                    if (Main.this.drawingMode == 1) {
                        Main.this.editorField.setActive(true, new Point(e.x, e.y));
                    } else if (Main.this.drawingMode == 2) {
                        Main.this.editorField.setActive(false, new Point(e.x, e.y));
                    }
                }
            });
            this.createMenuEditor();
            this.drawFieldEditor(this.editorField);
        }
    }

    private String createEmptyField(int numCols, int numRows) {
        String ret = "";
        int j = 0;
        while (j < numRows) {
            int i = 0;
            while (i < numCols) {
                ret = String.valueOf(ret) + "0";
                ++i;
            }
            if (j < numRows - 1) {
                ret = String.valueOf(ret) + ",";
            }
            ++j;
        }
        return ret;
    }

    private void drawFieldPlayer(int idx, Field field) {
        field.updateField(this.storage.get(idx));
        this.setText(String.valueOf(this.filename) + " " + (idx + 1) + " / " + this.storage.size());
    }

    private void drawFieldEditor(Field field) {
        field.updateField();
    }

    @Override
    protected void checkSubclass() {
    }

    public static Main getInstance() {
        return instance;
    }
}

