/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class Field
extends Canvas {
    private boolean[][] field;
    private int x;
    private int y;

    public Field(Composite parent, int style) {
        super(parent, style);
        this.setBackground(Colors.white);
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                Field.this.drawField(e.gc);
            }
        });
    }

    private void parseField(String field) {
        String[] parts = field.split(",");
        int numCols = parts[0].length();
        int numRows = parts.length;
        this.field = new boolean[numCols][numRows];
        int r = 0;
        while (r < numRows) {
            int c = 0;
            while (c < numCols) {
                this.field[c][r] = parts[r].charAt(c) != '0';
                ++c;
            }
            ++r;
        }
    }

    public void setActive(boolean active, int col, int row) {
        this.field[col][row] = active;
    }

    public void drawField(GC g) {
        int c = 0;
        while (c < this.field.length) {
            int r = 0;
            while (r < this.field[c].length) {
                if (this.field[c][r]) {
                    g.setBackground(Colors.red);
                } else {
                    g.setBackground(Colors.white);
                }
                g.fillRectangle(c * this.x, r * this.y, this.x, this.y);
                ++r;
            }
            ++c;
        }
    }

    @Override
    protected void checkSubclass() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateField(String field) {
        Main main = Main.getInstance();
        synchronized (main) {
            this.parseField(field);
            int numCols = this.field.length;
            int numRows = this.field[0].length;
            int maxWidth = this.getBounds().width;
            int maxHeight = this.getBounds().height;
            this.x = 1;
            while (numCols * this.x < maxWidth) {
                ++this.x;
            }
            --this.x;
            this.y = 1;
            while (numRows * this.y < maxHeight) {
                ++this.y;
            }
            --this.y;
            if (this.x < this.y) {
                this.y = this.x;
            } else {
                this.x = this.y;
            }
            this.redraw();
        }
    }

    public void setActive(boolean active, Point p) {
        int x = p.x / this.x;
        int y = p.y / this.y;
        int numCols = this.field[0].length;
        int numRows = this.field.length;
        if (x < numRows && y < numCols && x >= 0 && y >= 0) {
            this.setActive(active, x, y);
        }
        this.updateField();
    }

    public void updateField() {
        int numCols = this.field.length;
        int numRows = this.field[0].length;
        int maxWidth = this.getBounds().width;
        int maxHeight = this.getBounds().height;
        this.x = 1;
        while (numCols * this.x < maxWidth) {
            ++this.x;
        }
        --this.x;
        this.y = 1;
        while (numRows * this.y < maxHeight) {
            ++this.y;
        }
        --this.y;
        if (this.x < this.y) {
            this.y = this.x;
        } else {
            this.x = this.y;
        }
        this.redraw();
    }

    public String getString() {
        String f = "";
        int i = 0;
        while (i < this.field[0].length) {
            int j = 0;
            while (j < this.field.length) {
                f = this.field[j][i] ? String.valueOf(f) + "1" : String.valueOf(f) + "0";
                ++j;
            }
            if (i < this.field[0].length - 1) {
                f = String.valueOf(f) + ",";
            }
            ++i;
        }
        return f;
    }
}

