package com.example.mobapp_22;

import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.widget.ProgressBar;
import android.widget.TextView;

public class MainActivity extends Activity implements SensorEventListener {

	private SensorManager sensorManager;
	private Sensor sensorAcc;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		sensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
		
		sensorAcc = sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
				
  		ProgressBar pb = (ProgressBar)findViewById(R.id.progressBar1);
		pb.setMax(100);
		pb.setProgress(0);
	
 
	}

	  @Override
	  public final void onAccuracyChanged(Sensor sensor, int accuracy) {
	    // Do something here if sensor accuracy changes.
	  }

	  @Override
	  public final void onSensorChanged(SensorEvent event) {
		  TextView textView1 = (TextView)findViewById(R.id.textView1);
		  TextView textView2 = (TextView)findViewById(R.id.textView2);
		  TextView textView3 = (TextView)findViewById(R.id.textView3);
		  
		if (event.sensor==sensorAcc)
		{
		    textView1.setText("acc x "+event.values[0]);
		    textView2.setText("acc y "+event.values[1]);
		    textView3.setText("acc z "+event.values[2]);
		   
		    double v = event.values[0];
		    if (v<-5)
		    	v = -5.0;
		    else if (v>5)
		    	v = 5.0;
			ProgressBar pb = (ProgressBar)findViewById(R.id.progressBar1);			//pb.setMax(100);
			double val = 100.0 - (v*10 + 50);
			pb.setProgress((int)(val));
		}
	  }
	  
	  @Override
	  protected void onResume() {
	    super.onResume();
	    sensorManager.registerListener(this, sensorAcc, SensorManager.SENSOR_DELAY_NORMAL);
	  }

	  @Override
	  protected void onPause() {
	    super.onPause();
	    sensorManager.unregisterListener(this);
	  }
}
