package com.example.mobapp_30_actionbar;

import android.os.Bundle;
import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import android.widget.ToggleButton;

public class MainActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
	    // Handle presses on the action bar items
	    switch (item.getItemId()) {
	        case R.id.action_search:
	            showToast("search");
	            return true;
	        case R.id.action_settings:
	            showToast("settings");
	            return true;
	        case R.id.action_config:
	            showToast("config");
	            return true;
	        default:
	            return super.onOptionsItemSelected(item);
	    }
	}
	
	public void switchactionbar(View view)
	{
		ToggleButton tb = (ToggleButton)findViewById(R.id.toggleButton1);
		ActionBar actionBar = getActionBar();
		if (tb.isChecked())
		{
			actionBar.show();		
		}
		else
		{
			actionBar.hide();		
		}
	}
	
	private void showToast(String s) {
        Context context = getApplicationContext();
        int duration = Toast.LENGTH_SHORT;
        Toast toast = Toast.makeText(context, s, duration);
        toast.show();
    }

}
