// Author: A.Voss@FH-Aachen.de
//
// virtual
// tags: virtual

#include <iostream>
#include <cstdlib>
#include <vector>
using namespace std;

#include "../../include/tools.h"

#pragma GCC diagnostic ignored "-Wdelete-non-virtual-dtor"

// f is not virtual, g is
class A
{
public:
    void f()               { tools_log(); cout << "A::f" << endl; }
    virtual void g()       { tools_log(); cout << "A::g" << endl; }
};

// note: g is still virtual
class B : public A
{
public:
    void f()               { tools_log(); cout << "B::f" << endl; }
    void g()               { tools_log(); cout << "B::g" << endl; }
};

int main()
{
    tools_log(); cout << "example 1" << endl;
    A a;
    B b;
    
    // virtual plays no role! an object of type A calls functions of class A
    tools_log(); cout << "  a:" << endl;
    a.f();
    a.g();
    tools_log(); cout << "  b:" << endl;
    b.f();
    b.g();

    cout << endl;
    tools_log(); cout << "example 2" << endl;
    A *pa = new A(), *pb = new B();
    
    // virtual is important because we have ptrs of type A but
    // in fact one object of type A and one of type B (is also A)
    // -> virtual functions are needed to call the correct function g
    tools_log(); cout << "  pa:" << endl;
    pa->f();
    pa->g();
    tools_log(); cout << "  pb:" << endl;
    pb->f();
    pb->g();
    delete pa;
    delete pb;

    cout << endl;
    tools_log(); cout << "example 3" << endl;
    A &ra = a, &rb = b;
    
    // virtual is important because we have refs of type A but
    // in fact one object of type A and one of type B (is also A)
    // -> virtual functions are needed to call the correct function g
    // this is exactly the ptrs situation (example 2) but with refs
    tools_log(); cout << "  ra:" << endl;
    ra.f();
    ra.g();
    tools_log(); cout << "  rb:" << endl;
    rb.f();
    rb.g();

    cout << endl;
    tools_log(); cout << "example 3" << endl;

    return EXIT_SUCCESS;
}

