// Author: A.Voss@FH-Aachen.de
//
// class operators and temp. variables
// tags: operator+ += 

#include <iostream>
#include <cstdlib>
#include <string>
#include <cmath>
using namespace std;

#include "../../include/tools.h"

// here, we do not care if units are different ...
class Unit {
    double amount;
    string unit;
    
public:
    Unit(double a, const string & u) : amount(a), unit(u)
    { 
        tools_log(); cout << "ctor " << (*this) << endl;
    }
    
    Unit(const Unit & u) : amount(u.amount), unit(u.unit)
    { 
        tools_log(); cout << "ctor " << (*this) << endl;
    }

    Unit & operator=(const Unit & u)
    { 
        unit=u.unit; amount=u.amount; 
        tools_log(); cout << "op=  " << (*this) << endl;
        return *this;
    }
    
    // one way, as member (naive version)
    Unit operator+(const Unit & u_rhs) 
    {
        Unit result(*this);
        result.amount += u_rhs.amount;
        tools_log(); cout << "op+  " << result << endl;
        return result;
    }; 

    // or the other way, as friend (naive version)
    friend Unit operator-(const Unit & u_lhs, const Unit & u_rhs) 
    {
        Unit result(u_lhs);
        result.amount -= u_rhs.amount;
        tools_log(); cout << "op-  " << result << endl;
        return result;
    }; 
    
    friend ostream & operator<<(ostream & os, const Unit & u)
    {
        os << "(" << u.amount << " " << u.unit << ")";
        return os;
    }
        
};

int main()
{
    tools_log(); cout << "define objects" << endl;

    Unit weight1(1,"kg");
    Unit weight2(2,"kg");
    Unit weight3(weight2);
    
    cout << endl;
    tools_log(); cout << "call op=" << endl;
    weight3 = weight1;

    cout << endl;
    tools_log(); cout << "call op+" << endl;
    weight3 = weight1+weight2;

    cout << endl;
    tools_log(); cout << "call op-" << endl;
    weight3 = weight1-weight2;
    
    return EXIT_SUCCESS;
}

