package com.example.mobapp_b_gettingstarted;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import android.os.Build;

public class MainActivity extends ActionBarActivity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		if (savedInstanceState == null) {
			getSupportFragmentManager().beginTransaction()
					.add(R.id.container, new PlaceholderFragment()).commit();
		}

		Button btn1 = (Button) findViewById(R.id.button1);
	    Log.i("tag",(btn1==null)?"null":"notnull");  
	}
	@Override
	public void onSaveInstanceState(Bundle savedInstanceState) {
		Toast.makeText(this, "saveInstance", Toast.LENGTH_SHORT).show();	    
	    // Always call the superclass so it can save the view hierarchy state
	    super.onSaveInstanceState(savedInstanceState);
	}
	
	public void onRestoreInstanceState(Bundle savedInstanceState) {
	    // Always call the superclass so it can restore the view hierarchy
	    super.onRestoreInstanceState(savedInstanceState);

	    Toast.makeText(this, "restoreInstance", Toast.LENGTH_SHORT).show();	    
	}
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.punkt1) {
			Toast.makeText(this, "Punkt 1", Toast.LENGTH_SHORT).show();
			return true;
		}
		if (id == R.id.punkt2) {
			Toast.makeText(this, "Punkt 2", Toast.LENGTH_SHORT).show();
			return true;
		}
		if (id == R.id.punkt3) {
			Toast.makeText(this, "Punkt 3", Toast.LENGTH_SHORT).show();
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	@Override
	protected void onStart ()
	{
		super.onStart();
		Toast.makeText(this, "onStart", Toast.LENGTH_SHORT).show();
	}


	@Override
	protected void onPause ()
	{
		super.onPause();
		Toast.makeText(this, "onPause", Toast.LENGTH_SHORT).show();
	}

	@Override
	protected void onStop ()
	{
		super.onStop();
		Toast.makeText(this, "onStop", Toast.LENGTH_SHORT).show();
	}
	
	@Override
	protected void onResume ()
	{
		super.onResume();
		Toast.makeText(this, "onResume", Toast.LENGTH_SHORT).show();
	}

	@Override
	protected void onRestart ()
	{
		super.onRestart();
		Toast.makeText(this, "onRestart", Toast.LENGTH_SHORT).show();
	}

	@Override
	protected void onDestroy ()
	{
		super.onDestroy();
		Toast.makeText(this, "onDestroy", Toast.LENGTH_SHORT).show();
	}
	
	/**
	 * A placeholder fragment containing a simple view.
	 */
	public static class PlaceholderFragment 
	extends Fragment 
	implements OnClickListener {

		private View rootView;
		
		public PlaceholderFragment() {
		}

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container,
				Bundle savedInstanceState) {
			rootView = inflater.inflate(R.layout.fragment_main, container,
					false);

			SharedPreferences sharedPref = getActivity().getPreferences(Context.MODE_PRIVATE);
			String s = sharedPref.getString(getString(R.string.prefsKey), "leer");

			EditText editText1 = (EditText)rootView.findViewById(R.id.editText1);
			editText1.setText(s);

			Button btn1 = (Button) rootView.findViewById(R.id.button1);
		    btn1.setOnClickListener(this);  

		    Button btn2 = (Button) rootView.findViewById(R.id.button2);
			btn2.setOnClickListener(new OnClickListener(){
	            public void onClick(View v) {
	            		Intent intent = new Intent(v.getContext(), SecondActivity.class);
	            		startActivity(intent);
	            }
	        });

			return rootView;
		}
		public void onClick(View view) {
			EditText editText1 = (EditText)(rootView.findViewById(R.id.editText1));
			String s = editText1.getText().toString();
			
			SharedPreferences sharedPref = getActivity().getPreferences(Context.MODE_PRIVATE);
			SharedPreferences.Editor editor = sharedPref.edit();
			editor.putString(getString(R.string.prefsKey), s);
			editor.commit();
			
			Toast.makeText(view.getContext(), "saved", Toast.LENGTH_SHORT).show();
		}
	}

}
