package com.example.mobapp_g_startintents;

import java.util.List;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import android.os.Build;
import android.provider.MediaStore;

public class MainActivity extends ActionBarActivity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
	
	public void startIt(Intent intent)
	{
		PackageManager packageManager = getPackageManager();
		List<ResolveInfo> activities = packageManager.queryIntentActivities(intent, 0);
		if (activities.size() > 0)
			startActivity(intent);
		else
		{
			//Toast.makeText(this, "intent is not available", Toast.LENGTH_SHORT).show();
			LayoutInflater inflater = getLayoutInflater();
			View layout = inflater.inflate(R.layout.toast_layout,
			                               (ViewGroup) findViewById(R.id.toast_layout_root));

			TextView text = (TextView) layout.findViewById(R.id.text);
			text.setText("intent is not available");

			Toast toast = new Toast(getApplicationContext());
			toast.setGravity(Gravity.CENTER_VERTICAL, 0, 0);
			//toast.setGravity(Gravity.TOP|Gravity.LEFT, 0, 0);
			toast.setDuration(Toast.LENGTH_LONG);
			toast.setView(layout);
			toast.show();
		}
	}
	
	public void callPhone(View v)
	{
		Uri number = Uri.parse("tel:+49190123456");
		Intent callIntent = new Intent(Intent.ACTION_DIAL, number);
		startIt(callIntent);
	}
	
	public void showMap(View v)
	{
		// Map point based on address
		Uri location = Uri.parse("geo:0,0?q=1600+Amphitheatre+Parkway,+Mountain+View,+California");
		// Or map point based on latitude/longitude
		// Uri location = Uri.parse("geo:37.422219,-122.08364?z=14"); // z param is zoom level
		Intent mapIntent = new Intent(Intent.ACTION_VIEW, location);
		startIt(mapIntent);
	}
	
	public void showWeb(View v)
	{
		Uri webpage = Uri.parse("http://www.android.com");
		Intent webIntent = new Intent(Intent.ACTION_VIEW, webpage);
		startIt(webIntent);
	}

	static final int CAPTURE_REQUEST = 1;  // The request code
	
	public void makePhoto(View v)
	{
		Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
	    
		PackageManager packageManager = getPackageManager();
		List<ResolveInfo> activities = packageManager.queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY);
		if (activities.size() > 0)
		{
			startActivityForResult(intent, CAPTURE_REQUEST);
		}
	}
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
	    // Check which request we're responding to
	    if (requestCode == CAPTURE_REQUEST) {
	        if (resultCode == RESULT_OK) {
	        	Bundle extras = data.getExtras();
	            Bitmap mImageBitmap = (Bitmap) extras.get("data");
	            ImageView imageView = (ImageView)findViewById(R.id.imageView1);
	            imageView.setImageBitmap(mImageBitmap);
	        }
	    }
	}	
	
}
