package com.example.mobapp_i_gui1;

import android.support.v7.app.ActionBar.Tab;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.app.Fragment;
import android.app.FragmentTransaction;
//import android.support.v4.app.Fragment;
//import android.support.v4.app.FragmentTransaction;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Switch;
import android.widget.Toast;
import android.os.Build;

public class MainActivity extends ActionBarActivity 
implements ActionBar.TabListener{

	Fragment[] tabs = new TabFragment[3];
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		ActionBar actionBar = getSupportActionBar();
		//final ActionBar actionBar = getActionBar();
	    actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);

	    Bundle args;
	    
	    args = new Bundle();
	    args.putInt(TabFragment.TAB_LAYOUT_NUMBER,R.layout.fragment_tab0);
	    tabs[0] = new TabFragment();
	    tabs[0].setArguments(args);
	    
	    args = new Bundle();
	    args.putInt(TabFragment.TAB_LAYOUT_NUMBER,R.layout.fragment_tab1);
	    tabs[1] = new TabFragment();
	    tabs[1].setArguments(args);

	    args = new Bundle();
	    args.putInt(TabFragment.TAB_LAYOUT_NUMBER,R.layout.fragment_tab2);
	    tabs[2] = new TabFragment();
	    tabs[2].setArguments(args);
	  
	    // for each of the sections in the app, add a tab to the action bar.
	    actionBar.addTab(actionBar.newTab()
	    		.setText("Tab 0")
	        .setTabListener(this));
	    actionBar.addTab(actionBar.newTab()
	    		.setText("Tab 1")
	        .setTabListener(this));
	    actionBar.addTab(actionBar.newTab()
	    		.setText("Tab 2")
	        .setTabListener(this));
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			Switch sw = (Switch)findViewById(R.id.switch1);
			sw.setChecked(!sw.isChecked());
			hideActionBar(sw);
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	public void hideActionBar(View v)
	{
		ActionBar actionBar = getSupportActionBar();
		if (actionBar.isShowing())
			actionBar.hide();
		else
			actionBar.show();
	}

	public void fullScreen(View v)
	{
		Switch sw = (Switch)findViewById(R.id.switch2);
		if (sw.isChecked())
		{
			WindowManager.LayoutParams attrs = getWindow().getAttributes();
		    attrs.flags |= WindowManager.LayoutParams.FLAG_FULLSCREEN;
		    getWindow().setAttributes(attrs);	
		}
		else
		{
			WindowManager.LayoutParams attrs = getWindow().getAttributes();
		    attrs.flags &= (~WindowManager.LayoutParams.FLAG_FULLSCREEN);
		    getWindow().setAttributes(attrs);			
		}
	   }

	@Override
	public void onTabReselected(Tab arg0,
			android.support.v4.app.FragmentTransaction arg1) {
	}

	@Override
	public void onTabSelected(Tab arg0,
			android.support.v4.app.FragmentTransaction arg1) 
	{
		Toast.makeText(this, "tab "+arg0.getPosition()+" selected", Toast.LENGTH_SHORT).show();
		getFragmentManager().beginTransaction()
	        .replace(R.id.frame, tabs[arg0.getPosition()]).commit();	
	}

	@Override
	public void onTabUnselected(Tab arg0,
			android.support.v4.app.FragmentTransaction arg1) {
	}

	/**
	 * A placeholder fragment containing a simple view.
	 */
	public static class TabFragment extends Fragment {
	    public static final String TAB_LAYOUT_NUMBER = "Layout";
		
		public TabFragment() { }
		
		// it is recommended to use Bundles for arguments
		// public TabFragment(int Layout) { ...

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container,
				Bundle savedInstanceState) {
			
			int Layout = getArguments().getInt(TAB_LAYOUT_NUMBER);
			
			View rootView = inflater.inflate(Layout, container, false);
							
			return rootView;
		}
		
	}

}
