package com.example.mobapp_k_mouse1;

import com.example.mobapp_k_mouse1.R;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.support.v4.view.VelocityTrackerCompat;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.os.Build;

public class MainActivity extends ActionBarActivity {

	VelocityTracker mVelocityTracker = null;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
	@Override
	public boolean onTouchEvent(MotionEvent event){ 

		int index = event.getActionIndex();
        int action = event.getActionMasked();
        int pointerId = event.getPointerId(index);
        String s0 = "idx:"+index+" action:"+action+" id:"+pointerId;
        String s1 = " x:"+event.getRawX()+" y:"+event.getRawY();
		String s2 = "velocity ";
		
	    switch(action) {
	        case (MotionEvent.ACTION_DOWN) :
	        		if (mVelocityTracker == null) {
                    mVelocityTracker = VelocityTracker.obtain();
                }
                else {
                    mVelocityTracker.clear();
                }
                mVelocityTracker.addMovement(event);
	        		s1 = "down"+s1;
	        		break;
	        case (MotionEvent.ACTION_MOVE) :
                mVelocityTracker.addMovement(event);
                mVelocityTracker.computeCurrentVelocity(1000);
                s2 += " x:"+VelocityTrackerCompat.getXVelocity(mVelocityTracker,pointerId);
                s2 += " y:"+VelocityTrackerCompat.getYVelocity(mVelocityTracker,pointerId);
                s1 = "down"+s1;
	  	        	break;
	        case (MotionEvent.ACTION_UP) :
	      		s1 = "up"+s1;
	        		break;
	        case (MotionEvent.ACTION_CANCEL) :
	        		mVelocityTracker.recycle();
	        		break;
	        //case (MotionEvent.ACTION_OUTSIDE) :
	        default : 
	            return super.onTouchEvent(event);
	    }   

	    TextView textView0 = (TextView)findViewById(R.id.textView0);
	    TextView textView1 = (TextView)findViewById(R.id.textView1);
		TextView textView2 = (TextView)findViewById(R.id.textView2);
	    
		textView0.setText(s0);
		textView1.setText(s1);
		textView2.setText(s2);
		return true;
	     
	}
}
