package com.example.mobapp_l_database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.provider.BaseColumns;

public class SQLmydict extends SQLiteOpenHelper {
	private static SQLmydict sInstance;
	
    public abstract class mydictColumns implements BaseColumns {
        public static final String TABLE_NAME = "mydict";
        public static final String COLUMN_NAME_KEY = "key";
        public static final String COLUMN_NAME_VALUE = "value";
    }
	
    private static final int DATABASE_VERSION = 1;
    public static final String DATABASE_NAME = "mydict.db";
    
    public static final String MYDICT_TABLE_CREATE =
                "CREATE TABLE " + mydictColumns.TABLE_NAME + " (" +
                		mydictColumns._ID + " INTEGER PRIMARY KEY," +
                		mydictColumns.COLUMN_NAME_KEY + " TEXT, " +
                		mydictColumns.COLUMN_NAME_VALUE + " TEXT);";
    
    public static final String MYDICT_TABLE_DROP =
    		"DROP TABLE IF EXISTS " + mydictColumns.TABLE_NAME;

    public static SQLmydict getInstance(Context context) {
        if (sInstance == null) {
          sInstance = new SQLmydict(context.getApplicationContext());
        }
        return sInstance;
      }

    private SQLmydict(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(MYDICT_TABLE_CREATE);
    }

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		db.execSQL(MYDICT_TABLE_DROP);
        db.execSQL(MYDICT_TABLE_CREATE); // could also use onCreate
	}
}
