/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.hardware;

import android.content.Context;
import java.util.ArrayList;
import java.util.Iterator;
import org.openintents.sensorsimulator.hardware.SensorSimulatorClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sensor {
    public static final int TYPE_ACCELEROMETER = 1;
    public static final int TYPE_ALL = -1;
    public static final int TYPE_GYROSCOPE = 4;
    public static final int TYPE_LIGHT = 5;
    public static final int TYPE_MAGNETIC_FIELD = 2;
    public static final int TYPE_ORIENTATION = 3;
    public static final int TYPE_PRESSURE = 6;
    public static final int TYPE_PROXIMITY = 8;
    public static final int TYPE_TEMPERATURE = 7;
    public static final int TYPE_BARCODE_READER = 9;
    public static final int TYPE_LINEAR_ACCELERATION = 10;
    public static final int TYPE_GRAVITY = 11;
    public static final int TYPE_ROTATION_VECTOR = 12;
    public int sensorToRegister = 0;
    public int sensorToRemove = 0;
    private ArrayList<Integer> currentSensors = new ArrayList();
    private SensorSimulatorClient mClient;
    private Context mContext;

    protected Sensor(Context context, int type) {
        this.mContext = context;
        this.sensorToRegister = type;
    }

    protected void addSensor(int type) {
        this.sensorToRegister = type;
    }

    protected void removeSensor(int type) {
        this.sensorToRemove = type;
    }

    protected boolean checkList(int type) {
        Iterator<Integer> iter = this.currentSensors.iterator();
        while (iter.hasNext()) {
            if (iter.next() != type) continue;
            return false;
        }
        return true;
    }

    protected void addSensorToList(int type) {
        this.currentSensors.add(type);
    }

    protected void removeSensorFromList(int type) {
        if (this.currentSensors.size() == 1) {
            this.currentSensors = new ArrayList();
        } else {
            for (int i = 0; i < this.currentSensors.size(); ++i) {
                if (this.currentSensors.get(i) != type) continue;
                this.currentSensors.remove(i);
            }
        }
    }

    protected ArrayList<Integer> getList() {
        return this.currentSensors;
    }
}

