/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.hardware;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensorNames {
    private static final String TAG = "SensorNames";
    public static final String TYPE_ORIENTATION = "orientation";
    public static final String TYPE_ACCELEROMETER = "accelerometer";
    public static final String TYPE_TEMPERATURE = "temperature";
    public static final String TYPE_MAGNETIC_FIELD = "magnetic field";
    public static final String TYPE_LIGHT = "light";
    public static final String TYPE_GYROSCOPE = "gyroscope";
    public static final String TYPE_PROXIMITY = "proximity";
    public static final String TYPE_PRESSURE = "pressure";
    public static final String TYPE_BARCODE_READER = "barcode reader";
    public static final String TYPE_LINEAR_ACCELERATION = "linear acceleration";
    public static final String TYPE_GRAVITY = "gravity";
    public static final String TYPE_ROTATION_VECTOR = "rotation vector";
    public static final int SENSOR_MAX_BIT = 12;

    public static String getSensorName(int sensorInteger) {
        switch (sensorInteger) {
            case 1: {
                return TYPE_ACCELEROMETER;
            }
            case 2: {
                return TYPE_MAGNETIC_FIELD;
            }
            case 3: {
                return TYPE_ORIENTATION;
            }
            case 4: {
                return TYPE_GYROSCOPE;
            }
            case 5: {
                return TYPE_LIGHT;
            }
            case 6: {
                return TYPE_PRESSURE;
            }
            case 7: {
                return TYPE_TEMPERATURE;
            }
            case 8: {
                return TYPE_PROXIMITY;
            }
            case 9: {
                return TYPE_BARCODE_READER;
            }
            case 10: {
                return TYPE_LINEAR_ACCELERATION;
            }
            case 11: {
                return TYPE_GRAVITY;
            }
            case 12: {
                return TYPE_ROTATION_VECTOR;
            }
        }
        return null;
    }

    public static int getSensorInteger(String sensorName) {
        if (sensorName.equalsIgnoreCase(TYPE_ACCELEROMETER)) {
            return 1;
        }
        if (sensorName.equalsIgnoreCase(TYPE_GYROSCOPE)) {
            return 4;
        }
        if (sensorName.equalsIgnoreCase(TYPE_LIGHT)) {
            return 5;
        }
        if (sensorName.equalsIgnoreCase(TYPE_MAGNETIC_FIELD)) {
            return 2;
        }
        if (sensorName.equalsIgnoreCase(TYPE_ORIENTATION)) {
            return 3;
        }
        if (sensorName.equalsIgnoreCase(TYPE_PRESSURE)) {
            return 6;
        }
        if (sensorName.equalsIgnoreCase(TYPE_PROXIMITY)) {
            return 8;
        }
        if (sensorName.equalsIgnoreCase(TYPE_TEMPERATURE)) {
            return 7;
        }
        if (sensorName.equalsIgnoreCase(TYPE_BARCODE_READER)) {
            return 9;
        }
        if (sensorName.equalsIgnoreCase(TYPE_LINEAR_ACCELERATION)) {
            return 10;
        }
        if (sensorName.equalsIgnoreCase(TYPE_GRAVITY)) {
            return 11;
        }
        if (sensorName.equalsIgnoreCase(TYPE_ROTATION_VECTOR)) {
            return 12;
        }
        return 0;
    }

    public static ArrayList<String> getSensorNames(ArrayList<Integer> sensors) {
        ArrayList<String> sensorNames = new ArrayList<String>();
        for (int i = 0; i < sensors.size(); ++i) {
            for (int type = 1; type <= 12; ++type) {
                if (type != sensors.get(i)) continue;
                sensorNames.add(i, SensorNames.getSensorName(sensors.get(i)));
            }
        }
        return sensorNames;
    }

    public static ArrayList<Integer> getSensorsFromNames(String[] sensornames) {
        ArrayList<Integer> sensors = new ArrayList<Integer>();
        for (int i = 0; i < sensornames.length; ++i) {
            for (int type = 1; type <= 12; ++type) {
                if (!sensornames[i].equals(SensorNames.getSensorName(type))) continue;
                sensors.add(type);
            }
        }
        return sensors;
    }

    public static int getNumSensorValues(int sensor) {
        switch (sensor) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                return 3;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 1;
            }
        }
        return 0;
    }
}

