package com.example.mobapp_j_sensors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.os.Build;

public class MainActivity extends ActionBarActivity 
implements SensorEventListener {
	
	private SensorManager sensorManager;
	private Sensor sensorAcc;

	ArrayAdapter<String> adapter;
	ArrayList<String> entries;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		entries = new ArrayList<String>();
		adapter = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1, entries);
				
		ListView listView = (ListView) findViewById(R.id.listView1);
		listView.setAdapter(adapter);
						
		sensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);	

		List<Sensor> deviceSensors = sensorManager.getSensorList(Sensor.TYPE_ALL);
		for (Sensor s : deviceSensors) 
		{
			entries.add(s.getName()+" : "+s.getType());
		}
		
		adapter.notifyDataSetChanged();

		sensorAcc = sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
	  @Override
	  public final void onAccuracyChanged(Sensor sensor, int accuracy) {
	    // Do something here if sensor accuracy changes.
	  }

	  @Override
	  public final void onSensorChanged(SensorEvent event) {
		  TextView textView1 = (TextView)findViewById(R.id.textView2);
		  TextView textView2 = (TextView)findViewById(R.id.textView4);
		  TextView textView3 = (TextView)findViewById(R.id.textView6);
		  
		if (event.sensor==sensorAcc)
		{
		    textView1.setText(""+event.values[0]);
		    textView2.setText(""+event.values[1]);
		    textView3.setText(""+event.values[2]);		   
		}
	  }
	  
	  @Override
	  protected void onResume() {
	    super.onResume();
	    sensorManager.registerListener(this, sensorAcc, SensorManager.SENSOR_DELAY_NORMAL);
	  }

	  @Override
	  protected void onPause() {
	    super.onPause();
	    sensorManager.unregisterListener(this);
	  }

}
