/*	Author: A.Voss@FH-Aachen.de
 * 
 * 	Thema Lambda-Expressions
 */

#include <iostream>
#include <functional>
#include <vector>
#include <algorithm>
#include <cstdlib>
using namespace std;

#include "../../include/tools.h"

typedef double (*polynom_t)(double x);

double x3(double x) { return x*x*x; }

double eval(polynom_t p, double x)
{
	return p(x);
}

/*
double eval(function<double(double)> p, double x)
{
	return p(x);
} */

int main()
{
	// Variante 1
    tools_log(); cout << "2.0 ^ 3 = " << eval(x3,2.0) << endl;

	// Variante 2, mit lambda-expression
    tools_log(); cout << "2.0 ^ 3 = " << eval([](double x){return x*x*x;},2.0) << endl;

    auto lambda_x3 = [](double x){return x*x*x;};
	// Variante 3, ebenso
    tools_log(); cout << "2.0 ^ 3 = " << eval(lambda_x3,2.0) << endl;

	//function<double(double)> func_x3 = [](double x){return x*x*x;};
	// Variante 4, ebenso
    //tools_log(); cout << "2.0 ^ 3 = " << eval(func_x3,2.0) << endl;

    tools_log(); cout << "end of main" << endl;
    
    return EXIT_SUCCESS;
}

