/*	Author: A.Voss@FH-Aachen.de
 * 
 * 	Thema Lambda-Expressions
 */

#include <iostream>
#include <functional>
#include <vector>
#include <algorithm>
#include <cstdlib>
using namespace std;

#include "../../include/tools.h"


int main()
{
    // a simple lambda function
    auto add4 = [](int n) { return n+4; };
    tools_log(); cout << "add4(8) = " << add4(8) << '\n'; 
    
    int n = 5;
    // a lambda expression with a reference par. and no return type
    auto inc = [](int & n) {  ++n; };
    inc(n);
    tools_log(); cout << "n = " << n << '\n'; 
 
    double x1=1.0,x2=2.0;
    // note: "[=]" captures all values by copy, "[&]" by reference
    auto trapezrule = [=](function<double(double)> f){return 0.5*(f(x2)+f(x1))*(x2-x1); };
    
    double A;
    auto lambda_x2 = [](double x){return x*x;};
    A = trapezrule(lambda_x2);
    tools_log(); cout << "integral(x^2)_[a,b] = " << A << endl;
    A = trapezrule([](double x){return x*x*x;});
    tools_log(); cout << "integral(x^3)_[a,b] = " << A << endl;
    
    return EXIT_SUCCESS;
}

