package com.example.mobapp_o_useservice2;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import android.os.Build;
import com.example.mobapp_o_aidlservice.IUpperService;;

public class MainActivity extends ActionBarActivity {

	private UpperServiceServiceConnection serviceConnection;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		serviceConnection = new UpperServiceServiceConnection();
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	private static final String AIDL_SERVICE_CLASS = ".AIDLService";
	private static final String AIDL_SERVICE_PACKAGE = "com.example.mobapp_o_aidlservice";
	private static final String BIND_SERVICE = "mobapp.bindService";
	private final static String LOG_TAG = "AIDLService";

	public void startService1(View v) {
		if (!serviceConnection.isConnected())
		{
			Intent bindIntent = new Intent(BIND_SERVICE);
			bindIntent.setClassName(AIDL_SERVICE_PACKAGE, AIDL_SERVICE_PACKAGE + AIDL_SERVICE_CLASS);
			bindService(bindIntent, serviceConnection, Context.BIND_AUTO_CREATE);
		}
	}
	
	public void stopService1(View v) {
		if (serviceConnection.isConnected())
		{
			unbindService(serviceConnection);
			serviceConnection.disconnect();
		}
	}
	
	public void makeUpper(View v) {
		EditText text1 = (EditText)findViewById(R.id.editText1);
		EditText text2 = (EditText)findViewById(R.id.editText2);
		String s1 = text1.getText().toString(), s2;
		if (serviceConnection.isConnected()) {
			try {
				s2 = serviceConnection.upperservice.makeUpper(s1);
			} catch (RemoteException e) {
				e.printStackTrace();
				s2 = "oops";
			}
		} else {
			s2 = "not connected";
		}
		Log.d(LOG_TAG,"makeUpper "+s1+" -> "+s2);
		text2.setText(s2);
	}

	public class UpperServiceServiceConnection implements ServiceConnection {

		private IUpperService upperservice;
		private final static String LOG_TAG = "ServiceConnection";
		
		public boolean isConnected() {
			return upperservice!=null;
		}
		
		public void disconnect() {
			upperservice=null;
		}
		
		@Override
		public void onServiceConnected(ComponentName arg0, IBinder arg1) {
			upperservice = IUpperService.Stub.asInterface(arg1);
			Log.d(LOG_TAG,"service connected");
		}

		@Override
		public void onServiceDisconnected(ComponentName arg0) {
			// if unexpectedly disconnected (crash) 
			upperservice = null;
			Log.d(LOG_TAG,"service disconnected.");
		}

		
	}


}
