/*	Author: A.Voss@FH-Aachen.de
 * 
 * 	Thema variadic Template
 */

#include <iostream>
#include <cstdlib>
using namespace std;

#include "../../include/tools.h"

//	typ-sichere Funktionen mit variabler Anzahl von Parametern? Wie?

// Idee: rekursive typ-sichere Angabe der Parameter als Template-Parameter
// z.B so fuer Funktionen
template <typename T>
void my_printf(T t)
{
    cout << t;
}

template<typename T0, typename... TN>	// typename... !
void my_printf(T0 t0, TN... tn)       	// TN...       !
{
    cout << t0 << " ; ";
    my_printf(tn...);					// rekursiver Aufruf mit dem Rest
}

// Argumente zaehlen
template <typename... Args> 
struct NumberOfArgs {
    static const int value = sizeof...(Args);	// sizeof... !
};

// Klassen mit variabler Anzahl

// zunaechst Klasse deklarieren
template <typename... Args>
class MyTuple;

// dann rekursiv erben
template <typename T0, typename... TN>
class MyTuple<T0,TN...> : private MyTuple<TN...>
{
    T0 data;
public:
	// ein ctor mit variabler Anzahl
    MyTuple(const T0 & t0, const TN & ...tn) 
        : MyTuple<TN...>(tn...), data(t0)
    {}

	// um an die Daten zu kommen T0 und Tn
    T0 const& t0() const { return data; }

    const MyTuple<TN...> & tn() const { return *this; }
};

template <>
class MyTuple<>
{};


int main()
{
    tools_log(); cout << "use of variadic templates" << endl;
    
    tools_log(); cout << "  a set: { "; my_printf("text",12.34,-23,'X'); 
                 cout << " }" << endl;
    
    tools_log(); cout << "  number of tepl.args: " << NumberOfArgs<int,double,char>::value << endl;
    
    MyTuple<int,double> e(12,56.7);
    tools_log(); cout << "  first: " << e.t0() << ", second: " << e.tn().t0() << endl;

    return EXIT_SUCCESS;
}

