/*	Author: A.Voss@FH-Aachen.de
 * 
 * 	Thema Templates, user literals
 */

#include <iostream>
#include <cstdlib>
using namespace std;

#include "../../include/tools.h"

// Hilfsklasse um die Templates zu unterscheiden und die Einheiten
// auszugeben
struct DistanceUnit {
    static const char * unit() { return "m"; }
};
struct TimeUnit {
    static const char * unit() { return "s"; }
};
struct SpeedUnit {
    static const char * unit() { return "m/s"; }
};

// einfaches Template mit Wert und Einheit, z.B. 120m
template <typename T>
class Value {
public:
    typedef T unit_type;
    double value;
    
    Value(double v) : value(v) { }
    
    operator double() const { return value; }
    
    friend ostream & operator<<(ostream & os, const Value & v) {
        os << v.value << unit_type::unit();
        return os;
    }
};

// equivalent zu typedefs, erzeugt eine speziellen Typ; wegen der
// unterschiedlichen Template-Parameter sind es unterschiedliche Typen!
using Distance = Value<DistanceUnit>;
using Time = Value<TimeUnit>;
using Speed = Value<SpeedUnit>;

// es folgt, wie eigene user-literale angegeben werden koennen;
// das funktioniert nur fuer (long) doubles;
// Beispiel: 120.0_m
// die Funktionen geben ein Objekt entsprechenden Types zurueck
Distance operator"" _m(long double s) { return Distance((double)s); }
Time operator"" _s(long double s) { return Time((double)s); }

// und ein operator /  um eine Geschwindigkeit auszurechnen
Speed operator/(const Distance & d, const Time & t) { return Speed((double)d/(double)t); }

int main()
{
    tools_log(); cout << "use of user literals" << endl;

    // eine Geschwindigkeit, eine Zeit und daraus berechnet sich die 
    // Geschwindigkeit
    auto s = 120.0_m;	// entspricht: Distance s = 120.0_m;
    auto t = 10.0_s;
    auto v = s/t;
    
    tools_log(); cout << "  dist: " << s << ", time: " << t << ", speed: " << v << endl;
    
    // or explicitly in type
    Distance ac_k = 70.7_m*1000;
    tools_log(); cout << "  dist ac-k: " << ac_k << ", or, as double: " << (double)ac_k << endl;

    return EXIT_SUCCESS;
}

