package com.example.mobapp_p_gps;

import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBar;
import android.support.v4.app.Fragment;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import android.os.Build;

// see also
// http://www.androidhive.info/2012/07/android-gps-location-manager-tutorial/

public class MainActivity extends ActionBarActivity 
	implements LocationListener {

    boolean isNetworkEnabled = false;
    boolean isNetworkUsed = false;
    boolean isGPSEnabled = false;
    boolean isGPSUsed = false;
 
    LocationManager locationManager;
    Location location;
 
    // minTime: minimum time interval between location updates, in milliseconds
    static final long MIN_TIME = 1000*60; // 1 min
    // minDistance: minimum distance between location updates, in meters
    static final long MIN_DISTANCE = 10; // 10 m

    @Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		initLocation();

		TextView text5 = (TextView)findViewById(R.id.textView5);
		if (isNetworkUsed)
			text5.setText("Mode: Network");
		else if (isGPSUsed)
			text5.setText("Mode: GPS");
		else
			text5.setText("Mode: -");
	}
    
    public Location initLocation() {
        try {
            locationManager = (LocationManager)getSystemService(LOCATION_SERVICE);
            isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
            isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
 
            if (isNetworkEnabled)
            {
                locationManager.requestLocationUpdates(
                        LocationManager.NETWORK_PROVIDER,
                        MIN_TIME,
                        MIN_DISTANCE, this);
                location = locationManager
                        .getLastKnownLocation(LocationManager.NETWORK_PROVIDER);            	
                isNetworkUsed = (null!=location);
            }
            
            if (isGPSEnabled && !isNetworkUsed)
            {
                locationManager.requestLocationUpdates(
                        LocationManager.GPS_PROVIDER,
                        MIN_TIME,
                        MIN_DISTANCE, this);
                location = locationManager
                        .getLastKnownLocation(LocationManager.GPS_PROVIDER);           	
                isGPSUsed = (null!=location);
            }
 
        } catch (Exception e) {
            e.printStackTrace();
        }
 
        return location;
    }
    
    public void getGPS(View v)
    {
        TextView text3 = (TextView)findViewById(R.id.textView3);
        TextView text4 = (TextView)findViewById(R.id.textView4);
        
        text4.setText(""+getLatitude());
        text3.setText(""+getLongitude());                   
    }
    
    public double getLatitude()
    {
    		return (location != null) ? location.getLatitude() : 0;
    }
     
    public double getLongitude()
    {
    		return (location != null) ? location.getLongitude() : 0;
    }
   
    @Override
    public void onLocationChanged(Location location) {
    }
 
    @Override
    public void onProviderDisabled(String provider) {
    }
 
    @Override
    public void onProviderEnabled(String provider) {
    }
 
    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}


}
